/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.arraylist;

import ch.nolix.core.commontypetool.iteratortool.IterableTool;
import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.container.arraylist.ArrayListCapacityCalculator;
import ch.nolix.core.container.arraylist.ArrayListIterator;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.commoncontainer.CountRequestable;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import ch.nolix.coreapi.container.list.IArrayList;

public final class ArrayList<E>
extends AbstractExtendedContainer<E>
implements IArrayList<E> {
    private static final ArrayListCapacityCalculator ARRAY_LIST_CAPACITY_CALCULATOR = new ArrayListCapacityCalculator();
    private int elementCount;
    private E[] elements = new Object[0];

    private ArrayList() {
    }

    public static <E2> ArrayList<E2> createEmpty() {
        return new ArrayList();
    }

    public static <E2> ArrayList<E2> withElement(E2 element, E2 ... elements) {
        ArrayList<E2> arrayList = new ArrayList<E2>();
        arrayList.addAtEnd(element, elements);
        return arrayList;
    }

    public static <E2> ArrayList<E2> withElements(E2[] elements) {
        ArrayList<E2> arrayList = new ArrayList<E2>();
        arrayList.addAtEnd(elements);
        return arrayList;
    }

    public static <E2> ArrayList<E2> withInitialCapacity(int initialCapacity) {
        Validator.assertThat(initialCapacity).thatIsNamed("initial capacity").isNotNegative();
        ArrayList arrayList = new ArrayList();
        arrayList.growToCapacityWhenCapacityIsBiggerThanCurrentCapacity(initialCapacity);
        return arrayList;
    }

    public static <E2> ArrayList<E2> withInitialCapacityFromSizeOfContainer(CountRequestable<?> container) {
        int initialCapacity = container.getCount();
        return ArrayList.withInitialCapacity(initialCapacity);
    }

    private static int getCountOfIterable(Iterable<?> iterable) {
        if (iterable instanceof IContainer) {
            IContainer container = (IContainer)iterable;
            return container.getCount();
        }
        return IterableTool.getCount(iterable);
    }

    @Override
    public void addAtEnd(E element) {
        Validator.assertThat(element).thatIsNamed("element").isNotNull();
        int localElementCount = this.getCount();
        int newElementCount = localElementCount + 1;
        this.growAtLeastToRequiredCapacity(newElementCount);
        this.elements[localElementCount] = element;
        this.elementCount = newElementCount;
    }

    @Override
    public void addAtEnd(E element, E ... elements) {
        Validator.assertThat(element).thatIsNamed("element").isNotNull();
        Validator.assertThatTheElements(elements).areNotNull();
        int localElementCount = this.getCount();
        int newElementCount = localElementCount + 1 + elements.length;
        this.growAtLeastToRequiredCapacity(newElementCount);
        this.elements[localElementCount] = element;
        System.arraycopy(elements, 0, this.elements, localElementCount + 1, elements.length);
        this.elementCount = newElementCount;
    }

    @Override
    public void addAtEnd(E[] elements) {
        Validator.assertThatTheElements(elements).areNotNull();
        int localElementCount = this.getCount();
        int newElementCount = localElementCount + elements.length;
        this.growAtLeastToRequiredCapacity(newElementCount);
        System.arraycopy(elements, 0, this.elements, localElementCount, elements.length);
        this.elementCount = newElementCount;
    }

    @Override
    public void addAtEnd(Iterable<? extends E> elements) {
        Validator.assertThatTheElements(elements).areNotNull();
        int newElementCount = this.getCount() + ArrayList.getCountOfIterable(elements);
        this.growAtLeastToRequiredCapacity(newElementCount);
        int index = this.getCount();
        for (E e : elements) {
            this.elements[index] = e;
            ++index;
        }
        this.elementCount = newElementCount;
    }

    @Override
    public void clear() {
        this.elements = new Object[0];
        this.elementCount = 0;
    }

    @Override
    public IArrayList<E> getCopy() {
        return ArrayList.withElements(this.elements);
    }

    @Override
    public int getCount() {
        return this.elementCount;
    }

    @Override
    public E getStoredAtOneBasedIndex(int oneBasedIndex) {
        Validator.assertThat(oneBasedIndex).thatIsNamed("1 based index").isBetween(1, this.getCount());
        return this.elements[oneBasedIndex - 1];
    }

    @Override
    public boolean isMaterialized() {
        return true;
    }

    @Override
    public CopyableIterator<E> iterator() {
        return ArrayListIterator.forArrayAndMaxNextIndex(this.elements, this.getCount());
    }

    public String toString() {
        return this.toStringWithSeparator(',');
    }

    private int calculateTargetCapacityForRequiredCapacityWhenNeedsToGrowForIt(int requiredCapacity) {
        return ARRAY_LIST_CAPACITY_CALCULATOR.calculateTargetCapacityForActualCapacityAndRequiredCapacity(this.getCapacity(), requiredCapacity);
    }

    private int getCapacity() {
        return this.elements.length;
    }

    private void growAtLeastToRequiredCapacity(int requiredCapacity) {
        if (this.needsToGrowForRequiredCapacity(requiredCapacity)) {
            this.growAtLeastToRequiredCapacityWhenNeedsToGrowForIt(requiredCapacity);
        }
    }

    private void growAtLeastToRequiredCapacityWhenNeedsToGrowForIt(int requiredCapacity) {
        int targetCapacity = this.calculateTargetCapacityForRequiredCapacityWhenNeedsToGrowForIt(requiredCapacity);
        this.growToCapacityWhenCapacityIsBiggerThanCurrentCapacity(targetCapacity);
    }

    private void growToCapacityWhenCapacityIsBiggerThanCurrentCapacity(int capacity) {
        Object[] newElements = new Object[capacity];
        System.arraycopy(this.elements, 0, newElements, 0, this.getCount());
        this.elements = newElements;
    }

    private boolean needsToGrowForRequiredCapacity(int requiredCapacity) {
        return ARRAY_LIST_CAPACITY_CALCULATOR.arrayListNeedsToGrowForRequiredCapacity(this.getCapacity(), requiredCapacity);
    }
}

