/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.arraylist;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.math.main.Calculator;

public final class ArrayListCapacityCalculator {
    public boolean arrayListNeedsToGrowForRequiredCapacity(int capacity, int requiredCapacity) {
        return requiredCapacity > capacity;
    }

    public int calculateTargetCapacityForActualCapacityAndRequiredCapacity(int actualCapacity, int requiredCapacity) {
        Validator.assertThat(actualCapacity).thatIsNamed("actial capacity").isNotNegative();
        Validator.assertThat(requiredCapacity).thatIsNamed("required capacity").isNotNegative();
        if (actualCapacity > requiredCapacity) {
            if (actualCapacity / 3 > requiredCapacity) {
                return 2 * requiredCapacity;
            }
            return actualCapacity;
        }
        if (requiredCapacity > 1000000000) {
            return Integer.MAX_VALUE;
        }
        return Calculator.getMax(requiredCapacity, 2 * actualCapacity);
    }
}

