/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.arraylist;

import ch.nolix.core.commontypetool.iteratortool.IterableTool;
import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.container.arraylist.ArrayList;
import ch.nolix.core.container.arraylist.FilterContainerViewIterator;
import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import java.util.function.Predicate;

public final class FilterContainerView<E>
extends AbstractExtendedContainer<E> {
    private final IContainer<E> container;
    private final Predicate<E> selector;

    private FilterContainerView(IContainer<E> container, Predicate<E> selector) {
        Validator.assertThat(container).thatIsNamed("container").isNotNull();
        Validator.assertThat(selector).thatIsNamed("selector").isNotNull();
        this.container = container;
        this.selector = selector;
    }

    public static <T> FilterContainerView<T> createEmpty() {
        return FilterContainerView.forContainerAndSelector(ArrayList.createEmpty(), x -> true);
    }

    public static <T> FilterContainerView<T> forContainerAndSelector(IContainer<T> container, Predicate<T> selector) {
        return new FilterContainerView<T>(container, selector);
    }

    public static <T> FilterContainerView<T> forElementAndArrayAndSelector(T element, T[] array, Predicate<T> selector) {
        ContainerView<T> container = ContainerView.forElementAndArray(element, array);
        return FilterContainerView.forContainerAndSelector(container, selector);
    }

    @Override
    public int getCount() {
        return IterableTool.getCount(this);
    }

    @Override
    public E getStoredAtOneBasedIndex(int oneBasedIndex) {
        return IterableTool.getStoredAtOneBasedIndex(this, oneBasedIndex);
    }

    @Override
    public boolean isMaterialized() {
        return false;
    }

    @Override
    public CopyableIterator<E> iterator() {
        return FilterContainerViewIterator.forIteratorAndSelector(this.container.iterator(), this.selector);
    }

    public String toString() {
        return this.toStringWithSeparator(',');
    }
}

