/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.containerview;

import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.container.arraylist.ArrayList;
import ch.nolix.core.container.containerview.ArrayContainerView;
import ch.nolix.core.container.containerview.IterableContainerView;
import ch.nolix.core.container.containerview.MultiContainerViewIterator;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsOutOfRangeException;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.commoncontainer.CountRequestable;
import ch.nolix.coreapi.container.iterator.CopyableIterator;

public final class MultiContainerView<E>
extends AbstractExtendedContainer<E> {
    private final IContainer<IContainer<E>> containers;

    private MultiContainerView() {
        this.containers = ImmutableList.createEmpty();
    }

    private MultiContainerView(E[] array, E[] ... arrays) {
        ArrayList localContainers = ArrayList.createEmpty();
        localContainers.addAtEnd(ArrayContainerView.forArray(array));
        E[][] EArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            E[] a = EArray[n2];
            localContainers.addAtEnd(ArrayContainerView.forArray(a));
            ++n2;
        }
        this.containers = localContainers;
    }

    private MultiContainerView(Iterable<? extends E> iterable, Iterable<? extends E> ... iterables) {
        ArrayList localContainers = ArrayList.createEmpty();
        localContainers.addAtEnd(IterableContainerView.forIterable(iterable));
        Iterable<? extends E>[] iterableArray = iterables;
        int n = iterables.length;
        int n2 = 0;
        while (n2 < n) {
            Iterable<? extends E> i = iterableArray[n2];
            localContainers.addAtEnd(IterableContainerView.forIterable(i));
            ++n2;
        }
        this.containers = localContainers;
    }

    public static <E2> MultiContainerView<E2> forArray(E2[] array, E2[] ... arrays) {
        return new MultiContainerView<E2>(array, arrays);
    }

    public static <E2> MultiContainerView<E2> forEmpty() {
        return new MultiContainerView();
    }

    @SafeVarargs
    public static <E2> MultiContainerView<E2> forIterable(Iterable<? extends E2> iterable, Iterable<? extends E2> ... iterables) {
        return new MultiContainerView<E2>(iterable, iterables);
    }

    @Override
    public CopyableIterator<E> iterator() {
        return MultiContainerViewIterator.forContainers(this.containers);
    }

    @Override
    public int getCount() {
        return this.containers.getSumOfInts(CountRequestable::getCount).intValue();
    }

    @Override
    public E getStoredAtOneBasedIndex(int oneBasedIndex) {
        int i = 1;
        for (Object e : this) {
            if (i == oneBasedIndex) {
                return e;
            }
            ++i;
        }
        throw ArgumentIsOutOfRangeException.forArgumentAndArgumentNameAndRangeWithMinAndMax(oneBasedIndex, "1-based index", 1L, this.getCount());
    }

    @Override
    public boolean isMaterialized() {
        return false;
    }

    public String toString() {
        return this.toStringWithSeparator(',');
    }
}

