/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.immutablelist;

import ch.nolix.core.commontypetool.arraytool.ArrayIterator;
import ch.nolix.core.commontypetool.arraytool.ArrayTool;
import ch.nolix.core.commontypetool.iteratortool.IterableTool;
import ch.nolix.core.container.arraylist.AbstractExtendedContainer;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import java.util.stream.Stream;

public final class ImmutableList<E>
extends AbstractExtendedContainer<E> {
    private static final ArrayTool ARRAY_TOOL = new ArrayTool();
    private final E[] elements;

    private ImmutableList() {
        this.elements = new Object[0];
    }

    private ImmutableList(E[] elements) {
        this.elements = elements;
    }

    private ImmutableList(E element, E[] elements) {
        this.elements = ARRAY_TOOL.createArrayWithElement(element, elements);
        Validator.assertThatTheElements(elements).areNotNull();
    }

    public static <E2> ImmutableList<E2> createEmpty() {
        return new ImmutableList();
    }

    public static <E2> ImmutableList<E2> forArray(E2[] array) {
        return new ImmutableList<Object>((Object[])array.clone());
    }

    public static <E2> ImmutableList<E2> forIterable(Iterable<E2> container) {
        if (container instanceof ImmutableList) {
            ImmutableList immutableList = (ImmutableList)container;
            return immutableList;
        }
        int elementCount = IterableTool.getCount(container);
        Object[] elements = new Object[elementCount];
        int index = 0;
        for (E2 e : container) {
            if (e == null) {
                throw ArgumentIsNullException.forArgumentName(index + 1 + "th element");
            }
            elements[index] = e;
            ++index;
        }
        return new ImmutableList<Object>(elements);
    }

    public static <E2> ImmutableList<E2> fromStream(Stream<E2> stream) {
        Validator.assertThat(stream).thatIsNamed(Stream.class).isNotNull();
        return ImmutableList.forIterable(stream.toList());
    }

    public static <E2> ImmutableList<E2> withElement(E2 element, E2 ... elements) {
        return new ImmutableList<E2>(element, elements);
    }

    @Override
    public int getCount() {
        return this.elements.length;
    }

    @Override
    public E getStoredAtOneBasedIndex(int oneBasedIndex) {
        Validator.assertThat(oneBasedIndex).thatIsNamed("1-based index").isBetween(1, this.getCount());
        return this.elements[oneBasedIndex - 1];
    }

    @Override
    public boolean isMaterialized() {
        return true;
    }

    @Override
    public CopyableIterator<E> iterator() {
        return ArrayIterator.forArray(this.elements);
    }

    public String toString() {
        return this.toStringWithSeparator(',');
    }
}

