/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.matrix;

import ch.nolix.core.container.matrix.Matrix;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import java.util.NoSuchElementException;

public final class MatrixIterator<E>
implements CopyableIterator<E> {
    private final Matrix<E> parentMatrix;
    private int nextElementOneBasedIndex;

    private MatrixIterator(Matrix<E> parentMatrix) {
        Validator.assertThat(parentMatrix).thatIsNamed("parent Matrix").isNotNull();
        this.parentMatrix = parentMatrix;
        this.nextElementOneBasedIndex = 1;
    }

    private MatrixIterator(Matrix<E> parentMatrix, int oneBasedStartIndex) {
        Validator.assertThat(parentMatrix).thatIsNamed("parent Matrix").isNotNull();
        Validator.assertThat(oneBasedStartIndex).thatIsNamed("start index").isNotBiggerThan(parentMatrix.getCount());
        this.parentMatrix = parentMatrix;
        this.nextElementOneBasedIndex = oneBasedStartIndex;
    }

    public static <E2> MatrixIterator<E2> forMatrix(Matrix<E2> matrix) {
        return new MatrixIterator<E2>(matrix);
    }

    public static <E2> MatrixIterator<E2> forMatrixAndOneBasedStartIndex(Matrix<E2> matrix, int oneBasedStartIndex) {
        return new MatrixIterator<E2>(matrix, oneBasedStartIndex);
    }

    @Override
    public CopyableIterator<E> getCopy() {
        return MatrixIterator.forMatrixAndOneBasedStartIndex(this.parentMatrix, this.nextElementOneBasedIndex);
    }

    @Override
    public boolean hasNext() {
        return this.nextElementOneBasedIndex <= this.parentMatrix.getCount();
    }

    @Override
    public E next() {
        this.assertHasNext();
        return this.nextWhenHasNext();
    }

    private void assertHasNext() throws NoSuchElementException {
        if (!this.hasNext()) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, "next element").toNoSuchElementException();
        }
    }

    private E nextWhenHasNext() {
        E element = this.parentMatrix.getStoredAtOneBasedIndex(this.nextElementOneBasedIndex);
        ++this.nextElementOneBasedIndex;
        return element;
    }
}

