/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.container.sequencesearch;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.container.sequencesearch.SequencePatternNextMediator;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.programcontrol.flowcontrol.FlowController;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.iterator.CopyableIterator;
import ch.nolix.coreapi.container.sequencesearch.ISequencePattern;
import java.util.Iterator;
import java.util.function.Predicate;

public final class SequencePattern<E>
implements ISequencePattern<E> {
    private final IContainer<Predicate<E>> elementConditions;
    private final IContainer<Predicate<IContainer<E>>> sequenceConditions;
    private final Predicate<E> blankCondition = e -> true;

    private SequencePattern() {
        this(ImmutableList.createEmpty(), ImmutableList.createEmpty());
    }

    private SequencePattern(IContainer<Predicate<E>> elementConditions, IContainer<Predicate<IContainer<E>>> sequenceConditions) {
        this.elementConditions = ImmutableList.forIterable(elementConditions);
        this.sequenceConditions = ImmutableList.forIterable(sequenceConditions);
    }

    public static <E2> SequencePattern<E2> forElementType(Class<E2> elementType) {
        return new SequencePattern();
    }

    private static <T> SequencePattern<T> withElementConditionsAndSequenceConditions(IContainer<Predicate<T>> elementConditions, IContainer<Predicate<IContainer<T>>> sequenceConditions) {
        return new SequencePattern(elementConditions, sequenceConditions);
    }

    @Override
    public ISequencePattern<E> withBlankForNext() {
        return this.withConditionForNext(this.blankCondition);
    }

    @Override
    public ISequencePattern<E> withConditionForNext(Predicate<E> condition) {
        ContainerView allElementConditions = ContainerView.forIterableAndElement(this.elementConditions, condition, new Predicate[0]);
        return SequencePattern.withElementConditionsAndSequenceConditions(allElementConditions, this.sequenceConditions);
    }

    @Override
    public ISequencePattern<E> withConditionsForNexts(IContainer<Predicate<E>> conditions) {
        Validator.assertThatTheElements(conditions).areNotNull();
        ContainerView allElementConditions = ContainerView.forIterable(this.elementConditions, conditions);
        return SequencePattern.withElementConditionsAndSequenceConditions(allElementConditions, this.sequenceConditions);
    }

    @Override
    public ISequencePattern<E> withSequenceCondition(Predicate<IContainer<E>> sequenceCondition) {
        ContainerView newSequenceConditions = ContainerView.forIterableAndElement(this.sequenceConditions, sequenceCondition, new Predicate[0]);
        return SequencePattern.withElementConditionsAndSequenceConditions(this.elementConditions, newSequenceConditions);
    }

    @Override
    public SequencePatternNextMediator<E> forNext(int count) {
        return SequencePatternNextMediator.forSequencePatternAndCount(this, count);
    }

    @Override
    public IContainer<? extends IContainer<E>> getMatchingSequencesFrom(IContainer<E> list) {
        LinkedList sequences = LinkedList.createEmpty();
        int maxSequenceCount = list.getCount() - this.getSize() + 1;
        Iterator iterator = list.iterator();
        int i = 1;
        while (i <= maxSequenceCount) {
            boolean sequenceFulfillsElementConditions = true;
            CopyableIterator iterator2 = (CopyableIterator)iterator.getCopy();
            for (Predicate predicate : this.elementConditions) {
                Object element;
                if (predicate.test(element = iterator2.next())) continue;
                sequenceFulfillsElementConditions = false;
                break;
            }
            if (sequenceFulfillsElementConditions) {
                LinkedList linkedList = LinkedList.createEmpty();
                CopyableIterator iterator3 = (CopyableIterator)iterator.getCopy();
                FlowController.forCount(this.getSize()).run(() -> sequence.addAtEnd(iterator3.next()));
                if (this.sequenceConditions.containsOnly(sc -> sc.test(sequence))) {
                    sequences.addAtEnd(linkedList);
                }
            }
            iterator.next();
            ++i;
        }
        return sequences;
    }

    public int getSize() {
        return this.elementConditions.getCount();
    }

    public boolean matches(LinkedList<E> list) {
        if (list.getCount() != this.getSize()) {
            return false;
        }
        Iterator iterator = this.elementConditions.iterator();
        for (Object e : list) {
            if (((Predicate)iterator.next()).test(e)) continue;
            return false;
        }
        return this.sequenceConditions.containsOnly(sc -> sc.test(list));
    }
}

