/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.datastructure.pair;

import ch.nolix.core.commontypetool.stringtool.StringTool;
import ch.nolix.core.math.main.NumberComparator;

public final class FloatPair {
    public static final double DEFAULT_VALUE = 0.0;
    private final double value1;
    private final double value2;

    private FloatPair(double value1, double value2) {
        this.value1 = value1;
        this.value2 = value2;
    }

    public static FloatPair withValues(double value1, double value2) {
        return new FloatPair(value1, value2);
    }

    public boolean equals(Object object) {
        if (object instanceof FloatPair) {
            FloatPair floatPair = (FloatPair)object;
            return NumberComparator.areEqual(this.value1, floatPair.value1) && NumberComparator.areEqual(this.value2, floatPair.value2);
        }
        return false;
    }

    public double getValue1() {
        return this.value1;
    }

    public double getValue2() {
        return this.value2;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return StringTool.getInParentheses(this.getValue1(), this.getValue2());
    }
}

