/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.document.node;

import ch.nolix.core.commontypetool.stringtool.StringTool;
import ch.nolix.core.document.node.NodeComparator;
import ch.nolix.core.document.xml.MutableXmlNode;
import ch.nolix.core.environment.filesystem.FileSystemAccessor;
import ch.nolix.core.errorcontrol.invalidargumentexception.UnrepresentingArgumentException;
import ch.nolix.coreapi.attribute.optionalattribute.IOptionalHeaderHolder;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.document.node.INodeComparator;
import ch.nolix.coreapi.document.xml.IMutableXmlNode;
import ch.nolix.coreapi.programcontrol.processproperty.WriteMode;
import java.util.Optional;
import java.util.function.Predicate;

public abstract class AbstractNode<N extends AbstractNode<N>>
implements INode<N> {
    public static final String COMMA_CODE = "$M";
    public static final String DOLLAR_SYMBOL_CODE = "$X";
    public static final String OPEN_BRACKET_CODE = "$O";
    public static final String CLOSED_BRACKET_CODE = "$C";
    private static final INodeComparator NODE_COMPARATOR = new NodeComparator();

    public static String getEscapeStringFor(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int i = 0;
        while (i < string.length()) {
            switch (string.charAt(i)) {
                case ',': {
                    stringBuilder.append(COMMA_CODE);
                    break;
                }
                case '$': {
                    stringBuilder.append(DOLLAR_SYMBOL_CODE);
                    break;
                }
                case '(': {
                    stringBuilder.append(OPEN_BRACKET_CODE);
                    break;
                }
                case ')': {
                    stringBuilder.append(CLOSED_BRACKET_CODE);
                    break;
                }
                default: {
                    stringBuilder.append(string.charAt(i));
                }
            }
            ++i;
        }
        return stringBuilder.toString();
    }

    public static String getOriginStringFromEscapeString(String escapeString) {
        return escapeString.replace(COMMA_CODE, String.valueOf(',')).replace(OPEN_BRACKET_CODE, String.valueOf('(')).replace(CLOSED_BRACKET_CODE, String.valueOf(')')).replace(DOLLAR_SYMBOL_CODE, String.valueOf('$'));
    }

    @Override
    public final boolean containsChildNodes() {
        return this.getStoredChildNodes().containsAny();
    }

    @Override
    public final boolean containsChildNodeThat(Predicate<INode<?>> selector) {
        return this.getStoredChildNodes().containsAny(selector::test);
    }

    @Override
    public final boolean containsChildNodeWithHeader(String header) {
        return this.containsChildNodeThat(a -> a.hasHeader(header));
    }

    @Override
    public final boolean containsOneChildNode() {
        return this.getStoredChildNodes().containsOne();
    }

    public final boolean equals(Object object) {
        INode node;
        return object instanceof INode && NODE_COMPARATOR.areEqual(this, node = (INode)object);
    }

    @Override
    public final int getChildNodeCount() {
        return this.getStoredChildNodes().getCount();
    }

    @Override
    public final IContainer<String> getChildNodesHeaders() {
        return this.getStoredChildNodes().to(IOptionalHeaderHolder::getHeader);
    }

    @Override
    public Optional<N> getOptionalStoredFirstChildNodeThat(Predicate<INode<?>> selector) {
        return this.getStoredChildNodes().getOptionalStoredFirst(selector);
    }

    @Override
    public final N getStoredChildNodeAtOneBasedIndex(int index) {
        return (N)((AbstractNode)this.getStoredChildNodes().getStoredAtOneBasedIndex(index));
    }

    @Override
    public final IContainer<N> getStoredChildNodesWithHeader(String header) {
        return this.getStoredChildNodesThat(a -> a.hasHeader(header));
    }

    @Override
    public final IContainer<N> getStoredChildNodesThat(Predicate<INode<?>> selector) {
        return this.getStoredChildNodes().getStoredSelected(selector);
    }

    @Override
    public final N getStoredFirstChildNode() {
        return (N)((AbstractNode)this.getStoredChildNodes().getStoredFirst());
    }

    @Override
    public final N getStoredSingleChildNode() {
        return (N)((AbstractNode)this.getStoredChildNodes().getStoredOne());
    }

    @Override
    public final N getStoredFirstChildNodeThat(Predicate<INode<?>> selector) {
        return (N)((AbstractNode)this.getStoredChildNodes().getStoredFirst(selector));
    }

    @Override
    public final N getStoredFirstChildNodeWithHeader(String header) {
        return (N)this.getStoredFirstChildNodeThat((T a) -> a.hasHeader(header));
    }

    @Override
    public final boolean getSingleChildNodeAsBoolean() {
        return ((AbstractNode)this.getStoredSingleChildNode()).toBoolean();
    }

    @Override
    public final double getSingleChildNodeAsDouble() {
        return ((AbstractNode)this.getStoredSingleChildNode()).toDouble();
    }

    @Override
    public final int getSingleChildNodeAsInt() {
        return ((AbstractNode)this.getStoredSingleChildNode()).toInt();
    }

    @Override
    public final String getSingleChildNodeHeader() {
        return this.getStoredSingleChildNode().getHeader();
    }

    public final int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public final boolean isBlank() {
        return !this.hasHeader() && !this.containsChildNodes();
    }

    public final void saveToFile(String path) {
        this.saveToFile(path, WriteMode.THROW_EXCEPTION_WHEN_TARGET_EXISTS_ALREADY);
    }

    public final void saveToFile(String path, WriteMode writeMode) {
        FileSystemAccessor.createFile(path, writeMode, this.toFormattedString());
    }

    @Override
    public final boolean toBoolean() {
        return StringTool.toBoolean(this.toString());
    }

    @Override
    public final double toDouble() {
        return StringTool.toDouble(this.toString());
    }

    @Override
    public final String toFormattedString() {
        return this.toFormattedString(0);
    }

    @Override
    public final int toInt() {
        if (!this.hasHeader() || this.containsChildNodes()) {
            throw UnrepresentingArgumentException.forArgumentAndType(this, Integer.class);
        }
        try {
            return Integer.parseInt(this.getHeader());
        }
        catch (NumberFormatException numberFormatException) {
            throw UnrepresentingArgumentException.forArgumentAndType(this, Integer.class);
        }
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.hasHeader()) {
            stringBuilder.append(this.getReproducingHeader());
        }
        if (this.containsChildNodes()) {
            stringBuilder.append('(').append(this.getStoredChildNodes().toString()).append(')');
        }
        return stringBuilder.toString();
    }

    public final IMutableXmlNode toXml() {
        IMutableXmlNode xmlNode = MutableXmlNode.createBlankMutableXmlNode().setName(this.getHeader());
        for (AbstractNode cn : this.getStoredChildNodes()) {
            if (!cn.containsChildNodes()) {
                xmlNode.setValue(cn.toString());
                continue;
            }
            xmlNode.addChildNode(cn.toXml());
        }
        return xmlNode;
    }

    private void appendFormattedStringRepresentationOfChildNodesToStringBuilder(int leadingTabulators, StringBuilder stringBuilder) {
        if (this.getStoredChildNodes().containsNone(INode::containsChildNodes)) {
            stringBuilder.append('(').append(this.getStoredChildNodes().toString()).append(')');
        } else {
            stringBuilder.append('(').append('\n');
            int attributeCount = this.getChildNodeCount();
            int index = 1;
            for (AbstractNode cn : this.getStoredChildNodes()) {
                stringBuilder.append(cn.toFormattedString(leadingTabulators + 1));
                if (index < attributeCount) {
                    stringBuilder.append(',');
                }
                stringBuilder.append('\n');
                ++index;
            }
            stringBuilder.append(StringTool.createTabs(leadingTabulators)).append(')');
        }
    }

    private String getReproducingHeader() {
        return AbstractNode.getEscapeStringFor(this.getHeader());
    }

    private String toFormattedString(int leadingTabulators) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(StringTool.createTabs(leadingTabulators));
        if (this.hasHeader()) {
            stringBuilder.append(this.getReproducingHeader());
        }
        if (this.containsChildNodes()) {
            this.appendFormattedStringRepresentationOfChildNodesToStringBuilder(leadingTabulators, stringBuilder);
        }
        return stringBuilder.toString();
    }
}

