/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.environment.localcomputer;

import ch.nolix.core.container.containerview.ContainerView;
import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.validator.Validator;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public final class ShellProvider {
    private ShellProvider() {
    }

    public static void run(String[] command) {
        Validator.assertThat(command).thatIsNamed("command").isNotNull();
        String[] runtimeCommand = ShellProvider.createRuntimeCommandFromCommand(command);
        ShellProvider.runRuntimeCommand(runtimeCommand);
    }

    public static void startDefaultWebBrowserOpeningLoopBackAddress() {
        ShellProvider.startDefaultWebBrowserOpeningUrl("127.0.0.1");
    }

    public static void startDefaultWebBrowserOpeningUrl(String url) {
        try {
            Desktop.getDesktop().browse(new URI(ShellProvider.getUrlWithHttpPrefix(url)));
        }
        catch (IOException | URISyntaxException exception) {
            throw WrapperException.forError(exception);
        }
    }

    public static void startFirefox() {
        ShellProvider.run(new String[]{"start", "firefox"});
    }

    public static void startFirefox(String url) {
        ShellProvider.startFirefox(url, 80);
    }

    public static void startFirefox(String url, int port) {
        Validator.assertThat(url).thatIsNamed("url").isNotBlank();
        Validator.assertThat(port).thatIsNamed("port").isBetween(0, 65535);
        ShellProvider.run(new String[]{"start", "firefox", "--url", url + ":" + port});
    }

    public static void startFirefoxOpeningLoopBackAddress() {
        ShellProvider.startFirefox("127.0.0.1", 80);
    }

    public static void startFirefoxOpeningLoopBackAddress(int port) {
        ShellProvider.startFirefox("127.0.0.1", port);
    }

    private static String[] createRuntimeCommandFromCommand(String[] command) {
        String[] preCommand = new String[]{"cmd.exe", "/c"};
        return ContainerView.forArray(preCommand, new String[][]{command}).toStringArray();
    }

    private static String getUrlWithHttpPrefix(String url) {
        if (!url.startsWith("http://")) {
            return "http://" + url;
        }
        return url;
    }

    private static void runRuntimeCommand(String[] runtimeCommand) {
        try {
            Runtime.getRuntime().exec(runtimeCommand);
        }
        catch (IOException pIOException) {
            throw WrapperException.forError(pIOException);
        }
    }
}

