/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.environment.runningjar;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.coreapi.container.base.IContainer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public final class RunningJar {
    private RunningJar() {
    }

    public static String getResource(String path) {
        StringBuilder stringBuilder = new StringBuilder();
        InputStream inputStream = RunningJar.class.getResourceAsStream("/" + path);
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                String line = bufferedReader.readLine();
                while (line != null) {
                    stringBuilder.append(line).append("\n");
                    line = bufferedReader.readLine();
                }
                return stringBuilder.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException pIOException) {
            throw WrapperException.forError(pIOException);
        }
    }

    public static byte[] getResourceAsBytes(String path) {
        InputStream inputStream = RunningJar.class.getResourceAsStream("/" + path);
        try {
            return inputStream.readAllBytes();
        }
        catch (IOException pIOException) {
            throw WrapperException.forError(pIOException);
        }
    }

    public static IContainer<String> readLinesOfResource(String path) {
        LinkedList<String> lines = LinkedList.createEmpty();
        InputStream inputStream = RunningJar.class.getResourceAsStream("/" + path);
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    lines.addAtEnd(line);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioException) {
            throw WrapperException.forError(ioException);
        }
        return lines;
    }
}

