/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.errormapping;

import ch.nolix.core.errorcontrol.errormapping.ErrorMessageExtractor;
import ch.nolix.core.independent.list.List;
import ch.nolix.coreapi.errorcontrol.errormapping.IErrorMessageExtractor;

public final class StackTraceMapper {
    private static final IErrorMessageExtractor ERROR_MESSAGE_EXTRACTOR = new ErrorMessageExtractor();

    public String[] mapErrorToStackTrace(Throwable error) {
        List<String> list = new List<String>();
        this.mapOwnStackTraceElementsOfErrorIntoList(error, list);
        Throwable cause = error.getCause();
        while (cause != null) {
            this.mapCauseStackTraceIntoList(cause, list);
            cause = cause.getCause();
        }
        return List.createArrayFromList(list);
    }

    private void mapCauseStackTraceIntoList(Throwable cause, List<String> list) {
        String errorMessage = ERROR_MESSAGE_EXTRACTOR.getMessageOfError(cause);
        list.addAtEnd("Cause: " + cause.getClass().getSimpleName() + ": " + errorMessage);
        this.mapOwnStackTraceElementsOfErrorIntoList(cause, list);
    }

    private void mapOwnStackTraceElementsOfErrorIntoList(Throwable cause, List<String> list) {
        StackTraceElement[] stackTraceElementArray = cause.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ste = stackTraceElementArray[n2];
            list.addAtEnd(ste.toString());
            ++n2;
        }
    }
}

