/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.logging;

import ch.nolix.core.errorcontrol.logging.AbstractLogHandler;
import ch.nolix.core.errorcontrol.logging.FileLogHandler;
import ch.nolix.core.errorcontrol.logging.LogEntry;
import ch.nolix.core.errorcontrol.logging.LogWorker;
import ch.nolix.core.errorcontrol.logging.StandardConsoleLogHandler;
import ch.nolix.core.independent.list.List;
import ch.nolix.coreapi.errorcontrol.logging.HarmLevel;

public final class Logger {
    private static boolean active = true;
    private static LogWorker logWorker;
    private static final List<AbstractLogHandler> abstractLogHandlers;

    static {
        abstractLogHandlers = new List();
        abstractLogHandlers.addAtBegin(new StandardConsoleLogHandler());
        abstractLogHandlers.addAtBegin(new FileLogHandler());
    }

    private Logger() {
    }

    public static void addLogHandler(AbstractLogHandler abstractLogHandler) {
        abstractLogHandlers.addAtEnd(abstractLogHandler);
    }

    public static synchronized void disable() {
        if (active) {
            active = false;
            if (logWorker != null) {
                logWorker.inactivate();
                logWorker = null;
            }
        }
    }

    public static synchronized void enable() {
        if (!active) {
            active = true;
        }
    }

    public static boolean isActive() {
        return active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void logError(Throwable error) {
        if (!active) return;
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (logWorker == null) {
                logWorker = new LogWorker();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            LogEntry logEntry = LogEntry.forError(error);
            logWorker.takeLogEntry(logEntry);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void logError(String error) {
        if (!active) return;
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (logWorker == null) {
                logWorker = new LogWorker();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            logWorker.takeLogEntry(LogEntry.withMessageAndHarmLevel(error, HarmLevel.ERROR));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void logError(String valueName, double value, String errorPredicate) {
        if (!active) return;
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (logWorker == null) {
                logWorker = new LogWorker();
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            logWorker.takeLogEntry(LogEntry.withMessageAndHarmLevel("The " + valueName + " " + value + " " + errorPredicate + ".", HarmLevel.ERROR));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void logError(String valueName, long value, String errorPredicate) {
        if (!active) return;
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (logWorker == null) {
                logWorker = new LogWorker();
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            logWorker.takeLogEntry(LogEntry.withMessageAndHarmLevel("The " + valueName + " " + value + " " + errorPredicate + ".", HarmLevel.ERROR));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void logFatalError(String fatalError) {
        if (!active) return;
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (logWorker == null) {
                logWorker = new LogWorker();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            logWorker.takeLogEntry(LogEntry.withMessageAndHarmLevel(fatalError, HarmLevel.FATAL_ERROR));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void logInfo(String info) {
        if (!active) return;
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (logWorker == null) {
                logWorker = new LogWorker();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            logWorker.takeLogEntry(LogEntry.withMessageAndHarmLevel(info, HarmLevel.INFO));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void logInfo(String valueName, double value) {
        if (!active) return;
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (logWorker == null) {
                logWorker = new LogWorker();
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            logWorker.takeLogEntry(LogEntry.withMessageAndHarmLevel(valueName + " " + value, HarmLevel.INFO));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void logInfo(String valueName, long value) {
        if (!active) return;
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (logWorker == null) {
                logWorker = new LogWorker();
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            logWorker.takeLogEntry(LogEntry.withMessageAndHarmLevel(valueName + " " + value, HarmLevel.INFO));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void logWarning(String warning) {
        if (!active) return;
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            if (logWorker == null) {
                logWorker = new LogWorker();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            logWorker.takeLogEntry(LogEntry.withMessageAndHarmLevel(warning, HarmLevel.WARNING));
            return;
        }
    }

    static void takeLogEntry(LogEntry logEntry) {
        for (AbstractLogHandler lh : abstractLogHandlers) {
            lh.takeLogEntry(logEntry);
        }
    }

    static synchronized void removeLogWorker() {
        logWorker = null;
    }
}

