/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.errorcontrol.validator;

import ch.nolix.core.errorcontrol.invalidargumentexception.NegativeArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.NonPositiveArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.SmallerArgumentException;
import ch.nolix.core.errorcontrol.validator.ArgumentMediator;
import java.math.BigDecimal;

public class BigDecimalMediator
extends ArgumentMediator<BigDecimal> {
    BigDecimalMediator(BigDecimal argument) {
        super(argument);
    }

    BigDecimalMediator(String argumentName, BigDecimal argument) {
        super(argumentName, argument);
    }

    public final void isNotNegative() {
        this.isNotNull();
        if (((BigDecimal)this.getStoredArgument()).compareTo(BigDecimal.ZERO) < 0) {
            throw NegativeArgumentException.forArgumentAndArgumentName((BigDecimal)this.getStoredArgument(), this.getArgumentName());
        }
    }

    public final void isNotSmallerThan(BigDecimal value) {
        this.isNotNull();
        if (((BigDecimal)this.getStoredArgument()).compareTo(value) < 0) {
            throw SmallerArgumentException.forArgumentNameAndArgumentAndLimit((BigDecimal)this.getStoredArgument(), this.getArgumentName(), value);
        }
    }

    public final void isPositive() {
        this.isNotNull();
        if (((BigDecimal)this.getStoredArgument()).compareTo(BigDecimal.ZERO) <= 0) {
            throw NonPositiveArgumentException.forArgumentAndArgumentName((BigDecimal)this.getStoredArgument(), this.getArgumentName());
        }
    }
}

