/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.independent.list;

import java.util.NoSuchElementException;

final class ListNode<E> {
    private final E element;
    private ListNode<E> nextNode;

    public ListNode(E element) {
        if (element == null) {
            throw new IllegalArgumentException("The given element is null.");
        }
        this.element = element;
    }

    public boolean contains(E element) {
        return this.element == element;
    }

    public E getStoredElement() {
        return this.element;
    }

    public ListNode<E> getStoredNextNode() {
        this.assertHasNextNode();
        return this.nextNode;
    }

    public boolean hasNextNode() {
        return this.nextNode != null;
    }

    public void removeNextNode() {
        this.nextNode = null;
    }

    public void setNextNode(ListNode<E> nextNode) {
        if (nextNode == null) {
            throw new IllegalArgumentException("The given next node is null.");
        }
        this.nextNode = nextNode;
    }

    private void assertHasNextNode() {
        if (!this.hasNextNode()) {
            throw new NoSuchElementException("The current ListIterator does not have a next node.");
        }
    }
}

