/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.math.algebra;

import ch.nolix.core.commontypetool.arraytool.ArrayTool;
import ch.nolix.core.commontypetool.doubletool.DoubleTool;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.UnrepresentingArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.math.algebra.Polynom;
import ch.nolix.core.math.algebra.Vector;
import ch.nolix.core.math.main.NumberComparator;
import ch.nolix.coreapi.commontypetool.arraytool.IArrayTool;
import ch.nolix.coreapi.commontypetool.doubletool.IDoubleTool;
import java.util.Arrays;
import java.util.Random;

public final class Matrix {
    private static final IArrayTool ARRAY_TOOL = new ArrayTool();
    private static final IDoubleTool DOUBLE_TOOL = new DoubleTool();
    private static final Random RANDOM = new Random();
    private double[][] values;

    private Matrix(int length) {
        Validator.assertThat(length).thatIsNamed("length").isPositive();
        this.values = new double[length][length];
    }

    private Matrix(int rowCount, int columnCount) {
        Validator.assertThat(rowCount).thatIsNamed("row count").isPositive();
        Validator.assertThat(columnCount).thatIsNamed("column count").isPositive();
        this.values = new double[rowCount][columnCount];
    }

    public Matrix(int rowCount, int columnCount, double value) {
        this(rowCount, columnCount);
        this.setAllValuesTo(value);
    }

    public static Matrix createIdendityMatrixWithLength(int length) {
        return new Matrix(length).setDiagonalValuesTo(1.0);
    }

    public static Matrix createQuadraticMatrixWithOnesAndLength(int length) {
        return new Matrix(length).setAllValuesTo(1.0);
    }

    public static Matrix createRandomQuadraticMatrixWithLength(int length) {
        Validator.assertThat(length).thatIsNamed("length").isPositive();
        return Matrix.createRandomQuadraticMatrixWithRowCountAndColumnCount(length, length);
    }

    public static Matrix createRandomQuadraticMatrixWithRowCountAndColumnCount(int rowCount, int columnCount) {
        Matrix matrix = new Matrix(rowCount, columnCount);
        int i = 0;
        while (i < matrix.getRowCount()) {
            int j = 0;
            while (j < matrix.getColumnCount()) {
                matrix.values[i][j] = RANDOM.nextInt(100);
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public static Matrix withOnesAndRowCountAndColumnCount(int rowCount, int columnCount) {
        return new Matrix(rowCount, columnCount).setAllValuesTo(1.0);
    }

    public static Matrix withRowCountAndColumnCount(int rowCount, int columnCount) {
        return new Matrix(rowCount, columnCount);
    }

    public Matrix add(Matrix matrix) {
        Validator.assertThat(matrix.getRowCount()).thatIsNamed("number of rows of the given matrix").isEqualTo(this.getRowCount());
        Validator.assertThat(matrix.getColumnCount()).thatIsNamed("number of columns of the given matrix").isEqualTo(this.getColumnCount());
        int i = 0;
        while (i < this.getRowCount()) {
            int j = 0;
            while (j < this.getColumnCount()) {
                double[] dArray = this.values[i];
                int n = j;
                dArray[n] = dArray[n] + matrix.values[i][j];
                ++j;
            }
            ++i;
        }
        return this;
    }

    public Matrix appendAtRight(Matrix matrix) {
        Validator.assertThat(matrix.getRowCount()).thatIsNamed("number of rows of the given matrix").isEqualTo(this.getRowCount());
        int newColumnCount = this.getColumnCount() + matrix.getColumnCount();
        double[][] newValues = new double[this.getRowCount()][newColumnCount];
        int i = 0;
        while (i < this.getRowCount()) {
            newValues[i] = Arrays.copyOf(this.values[i], newColumnCount);
            int j = 0;
            while (j < matrix.getColumnCount()) {
                newValues[i][this.getColumnCount() + j] = matrix.values[i][j];
                ++j;
            }
            ++i;
        }
        this.values = newValues;
        return this;
    }

    public Matrix appendAtBottom(double rowValue, double ... rowValues) {
        int rowValueCount = rowValues.length + 1;
        Validator.assertThat(rowValueCount).thatIsNamed("number of row values").isEqualTo(this.getColumnCount());
        double[][] oldValues = this.values;
        this.values = (double[][])Arrays.copyOf(this.values, oldValues.length + 1);
        this.values[this.getRowCount() - 1] = ARRAY_TOOL.createArrayWithValue(rowValue, rowValues);
        return this;
    }

    public boolean equals(Object object) {
        if (object instanceof Matrix) {
            Matrix matrix = (Matrix)object;
            return this.equalsMatrix(matrix);
        }
        return false;
    }

    public int getColumnCount() {
        return this.values[0].length;
    }

    public Matrix getClone() {
        Matrix matrix = new Matrix(1);
        matrix.values = this.values;
        return matrix;
    }

    public Vector[] getColumnVectors() {
        Vector[] columns = new Vector[this.getColumnCount()];
        int j = 0;
        while (j < this.getColumnCount()) {
            double[] columnValues = new double[this.getRowCount()];
            int i = 0;
            while (i < this.getRowCount()) {
                columnValues[i] = this.values[i][j];
                ++i;
            }
            columns[j] = Vector.withValues(columnValues);
            ++j;
        }
        return columns;
    }

    public Matrix getInverse() {
        this.assertIsQuadratic();
        Matrix matrix = this.getClone().appendAtRight(Matrix.createIdendityMatrixWithLength(this.getRowCount())).tranformFirstPartToIdentityMatrix();
        if (matrix.getRowCount() < this.getRowCount()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is not regular");
        }
        return matrix.getMatrixWithLastColumns(this.getColumnCount());
    }

    public Matrix getMatrixWithFirstColumns(int columnCount) {
        Validator.assertThat(columnCount).thatIsNamed("column count").isBetween(1, this.getColumnCount());
        Matrix matrix = new Matrix(this.getRowCount(), columnCount);
        int i = 0;
        while (i < this.getRowCount()) {
            matrix.values[i] = Arrays.copyOf(this.values[i], columnCount);
            ++i;
        }
        return matrix;
    }

    public Matrix getMatrixWithLastColumns(int columnCount) {
        Validator.assertThat(columnCount).thatIsNamed("column count").isBetween(1, this.getColumnCount());
        Matrix matrix = new Matrix(this.getRowCount(), columnCount);
        int i = 0;
        while (i < this.getRowCount()) {
            int j = 0;
            while (j < columnCount) {
                matrix.values[i][j] = this.values[i][columnCount + j];
                ++j;
            }
            ++i;
        }
        return matrix;
    }

    public Matrix getMinimalFactorMatrix(Matrix solutionMatrix) {
        Validator.assertThat(solutionMatrix.getColumnCount()).thatIsNamed("number of columns of the given soluction matrix").isEqualTo(1);
        Validator.assertThat(solutionMatrix.getRowCount()).thatIsNamed("number of rows of the given solution matrix").isEqualTo(this.getRowCount());
        Matrix transposedMatrix = this.getTransposed();
        Matrix matrix = transposedMatrix.getProduct(this);
        Matrix inverseMatrix = null;
        try {
            inverseMatrix = matrix.getInverse();
        }
        catch (Throwable error) {
            inverseMatrix = matrix.getPseudoInverse();
        }
        return inverseMatrix.getProduct(transposedMatrix).getProduct(solutionMatrix);
    }

    public Matrix getProduct(Matrix matrix) {
        Validator.assertThat(matrix.getRowCount()).thatIsNamed("number of rows of the given matrix").isEqualTo(this.getColumnCount());
        Matrix product = new Matrix(this.getRowCount(), matrix.getColumnCount());
        int i = 0;
        while (i < product.getRowCount()) {
            int j = 0;
            while (j < product.getColumnCount()) {
                int k = 0;
                while (k < this.getColumnCount()) {
                    double[] dArray = product.values[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.values[i][k] * matrix.values[k][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return product;
    }

    public Matrix getPseudoInverse() {
        this.assertIsQuadratic();
        return this.getSum(new Matrix(this.getRowCount()).setDiagonalValuesTo(0.001)).getInverse();
    }

    public int getRank() {
        this.assertIsQuadratic();
        return this.getClone().transformToEquivalentUpperLeftMatrix().getRowCount();
    }

    public int getRowCount() {
        return this.values.length;
    }

    public Vector[] getRowVectors() {
        Vector[] rows = new Vector[this.getRowCount()];
        int i = 0;
        while (i < this.getRowCount()) {
            rows[i] = Vector.withValues(this.values[i]);
            ++i;
        }
        return rows;
    }

    public int getSize() {
        return this.getRowCount() * this.getColumnCount();
    }

    public double[] getSolutionAsExtendedMatrix() {
        Matrix matrix = this.getClone().transformToEquivalentUpperLeftMatrix();
        if (matrix.getRowCount() != this.getRowCount()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "does not have a regular coefficient Matrix");
        }
        double[] solution = new double[this.getRowCount()];
        int i = matrix.getRowCount() - 1;
        while (i >= 0) {
            double sum = matrix.values[i][matrix.getColumnCount() - 1];
            int j = matrix.getColumnCount() - 2;
            while (j > i) {
                sum -= matrix.values[i][j] * solution[j];
                --j;
            }
            solution[i] = sum / matrix.values[i][i];
            --i;
        }
        return solution;
    }

    public Matrix getSum(Matrix matrix) {
        return this.getClone().add(matrix);
    }

    public Matrix getTransposed() {
        return this.getClone().transpose();
    }

    public double getTrace() {
        this.assertIsQuadratic();
        double trace = 0.0;
        int i = 0;
        while (i < this.getRowCount()) {
            trace += this.values[i][i];
            ++i;
        }
        return trace;
    }

    public double getValue(int rowIndex, int columnIndex) {
        Validator.assertThat(rowIndex).thatIsNamed("row index").isBetween(1, this.getRowCount());
        Validator.assertThat(columnIndex).thatIsNamed("column index").isBetween(1, this.getColumnCount());
        return this.values[rowIndex - 1][columnIndex - 1];
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean hasSameSize(Matrix matrix) {
        return this.getRowCount() == matrix.getRowCount() && this.getColumnCount() == matrix.getColumnCount();
    }

    public boolean isIdentityMatrix() {
        if (!this.isQuadratic()) {
            return false;
        }
        int rowCount = this.getRowCount();
        int i = 1;
        while (i <= rowCount) {
            if (!this.canBeLineInIdentityMatrix(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isQuadratic() {
        return this.getRowCount() == this.getColumnCount();
    }

    public boolean isRegular() {
        return this.isQuadratic() && this.getRank() == this.getRowCount();
    }

    public Matrix multiply(double factor) {
        int i = 0;
        while (i < this.getRowCount()) {
            int j = 0;
            while (j < this.getColumnCount()) {
                double[] dArray = this.values[i];
                int n = j++;
                dArray[n] = dArray[n] * factor;
            }
            ++i;
        }
        return this;
    }

    public Matrix multiplyRow(int rowIndex, double factor) {
        Validator.assertThat(rowIndex).thatIsNamed("row index").isBetween(1, this.getRowCount());
        int i = 0;
        while (i < this.getColumnCount()) {
            double[] dArray = this.values[rowIndex];
            int n = i++;
            dArray[n] = dArray[n] * factor;
        }
        return this;
    }

    public Matrix removeZeroRows() {
        LinkedList newValues = LinkedList.createEmpty();
        double[][] dArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            double[] r = dArray[n2];
            boolean isZeroRow = true;
            double[] dArray2 = r;
            int n3 = r.length;
            int n4 = 0;
            while (n4 < n3) {
                double v = dArray2[n4];
                if (!NumberComparator.isZero(v)) {
                    isZeroRow = false;
                    break;
                }
                ++n4;
            }
            if (!isZeroRow) {
                newValues.addAtEnd(r);
            }
            ++n2;
        }
        this.values = new double[newValues.getCount()][this.values.length];
        int i = 0;
        while (i < newValues.getCount()) {
            this.values[i] = (double[])newValues.getStoredAtOneBasedIndex(i + 1);
            ++i;
        }
        return this;
    }

    public Matrix setAllValuesTo(double value) {
        int i = 0;
        while (i < this.values.length) {
            int j = 0;
            while (j < this.values[i].length) {
                this.values[i][j] = value;
                ++j;
            }
            ++i;
        }
        return this;
    }

    public Matrix setValue(int rowIndex, int columnIndex, double value) {
        Validator.assertThat(rowIndex).thatIsNamed("row index").isBetween(1, this.getRowCount());
        Validator.assertThat(columnIndex).thatIsNamed("column index").isBetween(1, this.getColumnCount());
        this.values[rowIndex - 1][columnIndex - 1] = value;
        return this;
    }

    public Matrix setValues(double value, double ... values) {
        int valueCount = 1 + values.length;
        Validator.assertThat(valueCount).isEqualTo(this.getColumnCount() * this.getRowCount());
        this.values[0][0] = value;
        int j = 1;
        while (j < this.getColumnCount()) {
            this.values[0][j] = values[j - 1];
            ++j;
        }
        int i = 1;
        while (i < this.getRowCount()) {
            int j2 = 0;
            while (j2 < this.getColumnCount()) {
                this.values[i][j2] = values[i * this.getColumnCount() + j2 - 1];
                ++j2;
            }
            ++i;
        }
        return this;
    }

    public Matrix setValues(double[] values) {
        Validator.assertThat(values).hasElementCount(this.getColumnCount() * this.getRowCount());
        int i = 0;
        while (i < this.getRowCount()) {
            int j = 0;
            while (j < this.getColumnCount()) {
                this.values[i][j] = values[i * this.getColumnCount() + j];
                this.values[i][j] = values[i * this.getColumnCount() + j - 1];
                ++j;
            }
            ++i;
        }
        return this;
    }

    public Matrix setDiagonalValuesTo(double value) {
        this.assertIsQuadratic();
        int i = 0;
        while (i < this.values.length) {
            this.values[i][i] = value;
            ++i;
        }
        return this;
    }

    public Matrix swapRows(int row1Index, int row2Index) {
        Validator.assertThat(row1Index).thatIsNamed("row index").isBetween(1, this.getRowCount());
        Validator.assertThat(row2Index).thatIsNamed("row index").isBetween(1, this.getRowCount());
        double[] temp = this.values[row1Index - 1];
        this.values[row1Index - 1] = this.values[row2Index - 1];
        this.values[row2Index - 1] = temp;
        return this;
    }

    public Polynom toPolynom() {
        if (NumberComparator.isZero(this.values[0][0])) {
            throw UnrepresentingArgumentException.forArgumentAndType(this, Polynom.class);
        }
        if (this.getRowCount() == 1) {
            return Polynom.withCoefficients(this.values[0]);
        }
        if (this.getColumnCount() == 1) {
            double[] lValues = new double[this.getRowCount()];
            int i = 0;
            while (i < this.getRowCount()) {
                lValues[i] = this.values[i][0];
                ++i;
            }
            return Polynom.withCoefficients(lValues);
        }
        throw UnrepresentingArgumentException.forArgumentAndType(this, Polynom.class);
    }

    public Vector toVector() {
        if (this.getRowCount() == 1) {
            return Vector.withValues(this.values[0]);
        }
        if (this.getColumnCount() == 1) {
            double[] lValues = new double[this.getRowCount()];
            int i = 0;
            while (i < this.getRowCount()) {
                lValues[i] = this.values[i][0];
                ++i;
            }
            return Vector.withValues(lValues);
        }
        throw UnrepresentingArgumentException.forArgumentAndType(this, Vector.class);
    }

    public Matrix tranformFirstPartToIdentityMatrix() {
        int rowCount = this.getRowCount();
        if (rowCount > this.getColumnCount()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "has more rows than columns");
        }
        this.transformToEquivalentUpperLeftMatrix();
        if (rowCount != this.getRowCount()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "has linear depending rows");
        }
        int i = this.getRowCount() - 1;
        while (i >= 0) {
            if (NumberComparator.isZero(this.values[i][i])) {
                throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "has linear depending rows");
            }
            double factor = 1.0 / this.values[i][i];
            int j = 0;
            while (j < this.getColumnCount()) {
                double[] dArray = this.values[i];
                int n = j++;
                dArray[n] = dArray[n] * factor;
            }
            j = i + 1;
            while (j < this.getRowCount()) {
                double factor2 = this.values[i][j];
                int k = 0;
                while (k < this.getColumnCount()) {
                    double[] dArray = this.values[i];
                    int n = k;
                    dArray[n] = dArray[n] - factor2 * this.values[j][k];
                    ++k;
                }
                ++j;
            }
            --i;
        }
        return this;
    }

    public Matrix transformToEquivalentUpperLeftMatrix() {
        int minColumnIndex = 0;
        int i = 0;
        while (i < this.values.length) {
            int j;
            boolean found = false;
            while (!found && minColumnIndex < this.values[i].length) {
                j = i;
                while (j < this.values.length) {
                    if (this.values[j][minColumnIndex] != 0.0) {
                        found = true;
                        this.swapRows(i + 1, j + 1);
                        break;
                    }
                    ++j;
                }
                if (found) continue;
                ++minColumnIndex;
            }
            if (!found) break;
            j = i + 1;
            while (j < this.values.length) {
                double factor = -this.values[j][minColumnIndex] / this.values[i][minColumnIndex];
                int k = minColumnIndex;
                while (k < this.values[j].length) {
                    double[] dArray = this.values[j];
                    int n = k;
                    dArray[n] = dArray[n] + factor * this.values[i][k];
                    ++k;
                }
                ++j;
            }
            ++minColumnIndex;
            ++i;
        }
        return this.removeZeroRows();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int i = 0;
        while (i < this.getRowCount()) {
            int j = 0;
            while (j < this.getColumnCount()) {
                stringBuilder.append(DOUBLE_TOOL.toString(this.values[i][j]));
                if (j < this.getColumnCount() - 1) {
                    stringBuilder.append(',');
                }
                ++j;
            }
            if (i < this.getRowCount() - 1) {
                stringBuilder.append(';');
            }
            ++i;
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    public Matrix transpose() {
        double[][] lValues = new double[this.getColumnCount()][this.getRowCount()];
        int i = 0;
        while (i < this.getRowCount()) {
            int j = 0;
            while (j < this.getColumnCount()) {
                lValues[j][i] = this.values[i][j];
                ++j;
            }
            ++i;
        }
        this.values = lValues;
        return this;
    }

    private void assertIsQuadratic() {
        if (!this.isQuadratic()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is not quadratic");
        }
    }

    private boolean canBeLineInIdentityMatrix(int lineIndex) {
        int columnCount = this.getColumnCount();
        int j = 0;
        while (j < columnCount) {
            if (lineIndex != j ? !NumberComparator.isZero(this.values[lineIndex - 1][j]) : !NumberComparator.isOne(this.values[lineIndex - 1][j])) {
                return false;
            }
            ++j;
        }
        return true;
    }

    private boolean equalsMatrix(Matrix matrix) {
        if (!this.hasSameSize(matrix)) {
            return false;
        }
        int i = 0;
        while (i < this.getRowCount()) {
            int j = 0;
            while (j < this.getColumnCount()) {
                if (!NumberComparator.areEqual(matrix.values[i][j], this.values[i][j])) {
                    return false;
                }
                ++j;
            }
            ++i;
        }
        return true;
    }
}

