/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.misc.license;

import ch.nolix.core.errorcontrol.invalidargumentexception.UnacceptedKeyException;
import ch.nolix.core.misc.license.KeyRefinder;
import ch.nolix.core.misc.license.LicenseValidator;
import ch.nolix.coreapi.misc.licenseapi.ILicense;
import ch.nolix.coreapi.misc.licenseapi.ILicenseValidator;

public abstract class License
implements ILicense {
    private static final ILicenseValidator LICENSE_VALIDATOR = new LicenseValidator();
    private boolean activated;

    @Override
    public final void activateWithKey(String key) {
        LICENSE_VALIDATOR.assertIsNotActivated(this);
        this.assertAcceptsKey(key);
        this.activated = true;
    }

    @Override
    public final String getName() {
        return this.getClass().getName();
    }

    @Override
    public final boolean isActivated() {
        return this.activated;
    }

    protected abstract boolean acceptsRefinedKey(String var1);

    private boolean acceptsKey(String key) {
        String refinedKey = KeyRefinder.getRefinedKeyFromKey(key);
        return this.acceptsRefinedKey(refinedKey);
    }

    private void assertAcceptsKey(String key) {
        if (!this.acceptsKey(key)) {
            throw UnacceptedKeyException.forKey(key);
        }
    }
}

