/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.misc.license;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.environment.filesystem.FolderAccessor;
import ch.nolix.core.errorcontrol.generalexception.GeneralException;
import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.misc.license.AbstractFeature;
import ch.nolix.core.misc.license.License;
import ch.nolix.core.misc.license.LicenseValidator;
import ch.nolix.core.misc.license.LongMediator;
import ch.nolix.core.reflection.reflectiontool.ReflectionTool;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.environment.nolixenvironment.NolixDirectoryAndFileCatalog;
import ch.nolix.coreapi.misc.licenseapi.ILicenseValidator;
import java.lang.reflect.InvocationTargetException;

public final class LicenseManagerUnit {
    private static final ILicenseValidator LICENSE_VALIDATOR = new LicenseValidator();
    private final LinkedList<License> licenses = LinkedList.createEmpty();

    public <L extends License> LicenseManagerUnit addLicense(Class<L> licenseType) {
        String key = this.readKeyFromLicenseFile(licenseType);
        License license = ReflectionTool.createInstanceFromDefaultConstructorOfClass(License.class);
        license.activateWithKey(key);
        this.addLicense(license);
        return this;
    }

    public LicenseManagerUnit addLicense(License license) {
        Validator.assertThat(license).thatIsNamed("license").isNotNull();
        LICENSE_VALIDATOR.assertIsActivated(license);
        if (!this.containsLicense(license.getClass())) {
            this.licenses.addAtEnd(license);
        }
        return this;
    }

    public <F extends AbstractFeature> boolean containsFeature(Class<F> featureType) {
        try {
            AbstractFeature feature = (AbstractFeature)featureType.getConstructor(new Class[0]).newInstance(new Object[0]);
            return feature.getAuthorizedLicenseTypes().containsAnyOf(this.getLicenseTypes());
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            throw WrapperException.forError(exception);
        }
    }

    public <L extends License> boolean containsLicense(Class<L> licenseType) {
        return this.licenses.containsAny(l -> l.getClass() == licenseType);
    }

    public IContainer<Class<?>> getLicenseTypes() {
        return this.licenses.to(Object::getClass);
    }

    public void removeLicense(License license) {
        this.licenses.removeStrictlyFirstOccurrenceOf(license);
    }

    public <F extends AbstractFeature> LicenseManagerUnit requireFeature(Class<F> featureType) {
        if (!this.containsFeature(featureType)) {
            throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeName(this, featureType.getSimpleName());
        }
        return this;
    }

    public LongMediator when(long value) {
        return new LongMediator(this, value);
    }

    private <L extends License> String readKeyFromLicenseFile(Class<L> licenseType) {
        Validator.assertThat(licenseType).thatIsNamed("type").isNotNull();
        return this.readKeyFromLicenseFile(licenseType.getName());
    }

    private String readKeyFromLicenseFile(String licenseName) {
        try {
            return new FolderAccessor(NolixDirectoryAndFileCatalog.NOLIX_CONFIGURATION_FILE_PATH).readFile(licenseName + ".license");
        }
        catch (Throwable error) {
            throw GeneralException.withErrorMessage("There does not exist a license file with the key for the License '" + licenseName + "'");
        }
    }
}

