/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint;

import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.endpoint.AbstractNetEndPoint;
import ch.nolix.core.net.endpoint.SocketEndPointMessageListener;
import ch.nolix.coreapi.net.endpointprotocol.MessageType;
import ch.nolix.coreapi.net.netproperty.ConnectionType;
import ch.nolix.coreapi.net.netproperty.PeerType;
import ch.nolix.coreapi.net.securityproperty.SecurityMode;
import ch.nolix.coreapi.programcontrol.processproperty.TargetInfoState;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;

public final class SocketEndPoint
extends AbstractNetEndPoint {
    private final PeerType peerType;
    private final Socket socket;
    private final InputStream socketInputStream;
    private final OutputStream socketOutputStream;

    public SocketEndPoint(int port) {
        this("::1", port);
    }

    public SocketEndPoint(int port, String target) {
        this("::1", port, target);
    }

    public SocketEndPoint(String ip) {
        this(ip, 80);
    }

    public SocketEndPoint(String ip, int port) {
        super(TargetInfoState.RECEIVED_TARGET_INFO);
        Validator.assertThat(port).thatIsNamed("port").isBetween(0, 65535);
        this.peerType = PeerType.FRONTEND;
        try {
            this.socket = new Socket(ip, port);
            this.socketInputStream = this.socket.getInputStream();
            this.socketOutputStream = this.socket.getOutputStream();
        }
        catch (IOException pIOException) {
            throw WrapperException.forError(pIOException);
        }
        this.sendTargetMessage();
        new SocketEndPointMessageListener(this);
    }

    public SocketEndPoint(String ip, int port, String target) {
        super(target);
        Validator.assertThat(port).thatIsNamed("port").isBetween(0, 65535);
        this.peerType = PeerType.FRONTEND;
        try {
            this.socket = new Socket(ip, port);
            this.socketInputStream = this.socket.getInputStream();
            this.socketOutputStream = this.socket.getOutputStream();
        }
        catch (IOException pIOException) {
            throw WrapperException.forError(pIOException);
        }
        this.sendTargetMessage();
        new SocketEndPointMessageListener(this);
    }

    SocketEndPoint(Socket socket, InputStream socketInputStream, OutputStream socketOutputStream) {
        super(TargetInfoState.RECEIVED_TARGET_INFO);
        Validator.assertThat(socket).thatIsNamed(Socket.class).isNotNull();
        Validator.assertThat(socketInputStream).thatIsNamed("socket input stream").isNotNull();
        Validator.assertThat(socketOutputStream).thatIsNamed("socket output stream").isNotNull();
        this.peerType = PeerType.BACKEND;
        this.socket = socket;
        this.socketInputStream = socketInputStream;
        this.socketOutputStream = socketOutputStream;
        new SocketEndPointMessageListener(this);
    }

    SocketEndPoint(Socket socket, InputStream socketInputStream, OutputStream socketOutputStream, String target) {
        super(target);
        Validator.assertThat(socket).thatIsNamed(Socket.class).isNotNull();
        Validator.assertThat(socketInputStream).thatIsNamed("socket input stream").isNotNull();
        Validator.assertThat(socketOutputStream).thatIsNamed("socket output stream").isNotNull();
        this.peerType = PeerType.BACKEND;
        this.socket = socket;
        this.socketInputStream = socketInputStream;
        this.socketOutputStream = socketOutputStream;
        new SocketEndPointMessageListener(this);
    }

    @Override
    public PeerType getPeerType() {
        return this.peerType;
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.SOCKET;
    }

    @Override
    public SecurityMode getSecurityMode() {
        return SecurityMode.NONE;
    }

    @Override
    public void noteClose() {
        if (this.canWork()) {
            try {
                this.sendRawMessage(MessageType.CLOSE_MESSAGE.getPrefix());
                this.socket.close();
            }
            catch (IOException pIOException) {
                throw WrapperException.forError(pIOException);
            }
        }
    }

    @Override
    protected void sendRawMessage(String rawMessage) {
        this.assertIsOpen();
        try {
            this.socketOutputStream.write((rawMessage + "\r\n").getBytes(StandardCharsets.UTF_8));
            this.socketOutputStream.flush();
        }
        catch (IOException pIOException) {
            throw WrapperException.forError(pIOException);
        }
    }

    InputStream getStoredInputStream() {
        return this.socketInputStream;
    }

    private boolean canWork() {
        return !this.socket.isClosed();
    }
}

