/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint;

import ch.nolix.core.commontypetool.inputstreamtool.InputStreamTool;
import ch.nolix.core.commontypetool.stringtool.StringTool;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.document.node.Node;
import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.core.errorcontrol.logging.Logger;
import ch.nolix.core.net.endpoint.Server;
import ch.nolix.core.net.endpoint.SocketEndPoint;
import ch.nolix.core.net.endpoint.WebSocketEndPoint;
import ch.nolix.core.net.http.HttpRequest;
import ch.nolix.core.net.websocket.WebSocketHandShakeRequest;
import ch.nolix.coreapi.commontypetool.inputstreamtool.IInputStreamTool;
import ch.nolix.coreapi.net.endpoint.IEndPoint;
import ch.nolix.coreapi.net.endpoint.SocketType;
import ch.nolix.coreapi.net.endpointprotocol.MessageType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public final class SocketHandler {
    private static final IInputStreamTool INPUT_STREAM_TOOL = new InputStreamTool();

    public void handleSocketForServer(Socket socket, Server server) {
        Optional<IEndPoint> backendNetEndPoint = this.createOptionalBackendNetEndPointForSocketAndServer(socket, server);
        if (backendNetEndPoint.isEmpty()) {
            this.closeSocket(socket);
        } else {
            server.internalTakeBackendEndPoint(backendNetEndPoint.get());
        }
    }

    private void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException ioException) {
            throw WrapperException.forError(ioException);
        }
    }

    private Optional<IEndPoint> createOptionalBackendNetEndPointForSocketAndServer(Socket socket, InputStream socketInputStream, OutputStream socketOutputStream, String firstReveivedLine, SocketType socketType, Server server) {
        return switch (socketType) {
            case SocketType.NET_SOCKET_WITH_DEFAULT_TARGET -> Optional.of(this.createSocketEndPointWithDefaultTarget(socket, socketInputStream, socketOutputStream));
            case SocketType.NET_SOCKET_WITH_CUSTOM_TARGET -> Optional.of(this.createSocketEndPointWithCustomTarget(socket, socketInputStream, socketOutputStream, firstReveivedLine));
            case SocketType.HTTP_SOCKET_OR_WEB_SOCKET -> this.createOptionalBackendNetEndPointForSocketAndServerWhenIsHttpSocketOrWebSocket(socket, socketInputStream, socketOutputStream, firstReveivedLine, server);
            default -> throw new MatchException(null, null);
        };
    }

    private Optional<IEndPoint> createOptionalBackendNetEndPointForSocketAndServer(Socket socket, Server server) {
        Optional<InputStream> socketInputStream = this.getOptionalInputStreamOfSocket(socket);
        Optional<OutputStream> socketOutputStream = this.getOptionalOutputStreamOfSocket(socket);
        if (socketInputStream.isEmpty() || socketOutputStream.isEmpty()) {
            return Optional.empty();
        }
        String firstReveivedLine = INPUT_STREAM_TOOL.readLineFromInputStream(socketInputStream.get());
        Logger.logInfo("The current SocketHandler received the first line from the given socket: " + StringTool.getInSingleQuotes(firstReveivedLine));
        Optional<SocketType> socketType = this.getSocketTypeFromFirstReceivedLine(firstReveivedLine);
        if (socketType.isEmpty()) {
            return Optional.empty();
        }
        return this.createOptionalBackendNetEndPointForSocketAndServer(socket, socketInputStream.get(), socketOutputStream.get(), firstReveivedLine, socketType.get(), server);
    }

    private Optional<IEndPoint> createOptionalBackendNetEndPointForSocketAndServerWhenIsHttpSocketOrWebSocket(Socket socket, InputStream socketInputStream, OutputStream socketOutputStream, String firstReveivedLine, Server server) {
        LinkedList<String> lines = LinkedList.withElement(firstReveivedLine, new String[0]);
        this.fillUpLinesIntoListUntilReceivesEmptyLine(lines, socketInputStream);
        if (WebSocketHandShakeRequest.canBe(lines)) {
            Logger.logInfo("The current SocketHandler has received the web socket opening handshake request: " + StringTool.getInSingleQuotes(lines.toString()));
            String openingHandshakeResponse = new WebSocketHandShakeRequest(lines).getWebSocketHandShakeResponse().toString();
            Logger.logInfo("The current SocketHandler sends the opening handshake response: " + StringTool.getInSingleQuotes(openingHandshakeResponse));
            this.sendRawMessageToOutputStream(socketOutputStream, openingHandshakeResponse);
            return Optional.of(new WebSocketEndPoint(socket, socketInputStream, socketOutputStream));
        }
        if (HttpRequest.canBe(lines)) {
            this.sendRawMessageToOutputStream(socketOutputStream, server.getInitialHttpMessage());
        }
        return Optional.empty();
    }

    private SocketEndPoint createSocketEndPointWithCustomTarget(Socket socket, InputStream socketInputStream, OutputStream socketOutputStream, String firstReveivedLine) {
        return new SocketEndPoint(socket, socketInputStream, socketOutputStream, Node.fromString(firstReveivedLine.substring(1)).getHeader());
    }

    private SocketEndPoint createSocketEndPointWithDefaultTarget(Socket socket, InputStream socketInputStream, OutputStream socketOutputStream) {
        return new SocketEndPoint(socket, socketInputStream, socketOutputStream);
    }

    private void fillUpLinesIntoListUntilReceivesEmptyLine(LinkedList<String> lines, InputStream inputStream) {
        while (true) {
            String line;
            if ((line = INPUT_STREAM_TOOL.readLineFromInputStream(inputStream)) == null) {
                throw ArgumentIsNullException.forArgumentName("line");
            }
            if (line.isEmpty()) break;
            lines.addAtEnd(line);
        }
    }

    private Optional<InputStream> getOptionalInputStreamOfSocket(Socket socket) {
        try {
            return Optional.of(socket.getInputStream());
        }
        catch (IOException ioException) {
            Logger.logError(ioException);
            return Optional.empty();
        }
    }

    private Optional<OutputStream> getOptionalOutputStreamOfSocket(Socket socket) {
        try {
            return Optional.of(socket.getOutputStream());
        }
        catch (IOException ioException) {
            Logger.logError(ioException);
            return Optional.empty();
        }
    }

    private Optional<SocketType> getSocketTypeFromFirstReceivedLine(String firstReceivedLine) {
        if (firstReceivedLine.equals(MessageType.DEFAULT_TARGET_MESSAGE.getPrefix())) {
            return Optional.of(SocketType.NET_SOCKET_WITH_DEFAULT_TARGET);
        }
        if (firstReceivedLine.startsWith(MessageType.TARGET_MESSAGE.getPrefix())) {
            return Optional.of(SocketType.NET_SOCKET_WITH_CUSTOM_TARGET);
        }
        if (firstReceivedLine.startsWith("G")) {
            return Optional.of(SocketType.HTTP_SOCKET_OR_WEB_SOCKET);
        }
        return Optional.empty();
    }

    private void sendRawMessageToOutputStream(OutputStream outputStream, String rawMessage) {
        try {
            outputStream.write(rawMessage.getBytes(StandardCharsets.UTF_8));
            outputStream.flush();
        }
        catch (IOException ioException) {
            throw WrapperException.forError(ioException);
        }
    }
}

