/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint;

import ch.nolix.core.net.endpoint.SslServer;
import ch.nolix.core.net.endpoint.SslServerChannelInboundHandler;
import ch.nolix.core.net.endpoint.SslServerIndexPageHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolHandler;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.ssl.SslContext;

final class SslServerInitializer
extends ChannelInitializer<SocketChannel> {
    private static final String WEBSOCKET_PATH = "/websocket";
    private final SslServer parentWebSocketServer;
    private final String htmlPage;
    private final SslContext sslCtx;

    public SslServerInitializer(SslServer parentWebSocketServer, String htmlPage, SslContext sslCtx) {
        this.parentWebSocketServer = parentWebSocketServer;
        this.htmlPage = htmlPage;
        this.sslCtx = sslCtx;
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.sslCtx != null) {
            pipeline.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
        pipeline.addLast(new ChannelHandler[]{new WebSocketServerProtocolHandler(WEBSOCKET_PATH, null, true)});
        pipeline.addLast(new ChannelHandler[]{new SslServerIndexPageHandler(this.htmlPage)});
        pipeline.addLast(new ChannelHandler[]{new SslServerChannelInboundHandler(this.parentWebSocketServer)});
    }
}

