/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.endpoint;

import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.net.endpoint.SslServer;
import ch.nolix.core.net.endpoint.SslServerInitializer;
import ch.nolix.core.net.endpoint.SslServerSslContextCreator;
import ch.nolix.core.programcontrol.worker.AbstractWorker;
import ch.nolix.coreapi.net.ssl.ISslCertificate;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;

final class SslServerWorker
extends AbstractWorker {
    private static final SslServerSslContextCreator SECURE_SERVER_SSL_CONTEXT_CREATOR = new SslServerSslContextCreator();
    private final SslServer parentWebSocketServer;
    private final int port;
    private final String htmlPage;
    private final ISslCertificate mSSLCertificate;
    private Channel channel;

    public SslServerWorker(SslServer parentWebSocketServer, int port, String htmlPage, ISslCertificate paramSSLCertificate) {
        Validator.assertThat(parentWebSocketServer).thatIsNamed("parent web-socket server").isNotNull();
        Validator.assertThat(port).thatIsNamed("port").isPort();
        Validator.assertThat(paramSSLCertificate).thatIsNamed(ISslCertificate.class).isNotNull();
        this.parentWebSocketServer = parentWebSocketServer;
        this.port = port;
        this.htmlPage = htmlPage;
        this.mSSLCertificate = paramSSLCertificate;
        this.start();
    }

    @Override
    protected void run() {
        SslContext sslContext = SECURE_SERVER_SSL_CONTEXT_CREATOR.createSSLContext(this.mSSLCertificate);
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        try {
            try {
                ServerBootstrap serverBootstrab = ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().childOption(ChannelOption.TCP_NODELAY, (Object)true).group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new SslServerInitializer(this.parentWebSocketServer, this.htmlPage, sslContext));
                this.channel = serverBootstrab.bind(this.port).sync().channel();
                this.channel.closeFuture().sync();
            }
            catch (InterruptedException interruptedException) {
                throw WrapperException.forError(interruptedException);
            }
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    void internalStop() {
        this.channel.close();
        this.channel.parent().close();
    }
}

