/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.messaging;

import ch.nolix.core.errorcontrol.validator.Validator;

public class IndexedPackage<C> {
    private final int index;
    private final C content;

    protected IndexedPackage(int index, C content) {
        Validator.assertThat(content).thatIsNamed("content").isNotNull();
        this.index = index;
        this.content = content;
    }

    public static <C2> IndexedPackage<C2> withIndexAndContent(int index, C2 content) {
        return new IndexedPackage<C2>(index, content);
    }

    public final C getStoredContent() {
        return this.content;
    }

    public final int getIndex() {
        return this.index;
    }

    public final boolean hasIndex(int index) {
        return this.getIndex() == index;
    }
}

