/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.net.ssl;

import ch.nolix.core.document.node.Node;
import ch.nolix.core.environment.nolixenvironment.NolixEnvironmentService;
import ch.nolix.core.net.ssl.SslCertificate;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.net.ssl.ISslCertificate;

public final class NolixConfigurationSSLCertificateReader {
    private static final String DEFAULT_SSL_CERTIFICATE_HEADER = "DefaultSSLCertificate";
    private static final String DOMAIN_HEADER = "Domain";
    private static final String PUBLIC_KEY_PEM_FILE_HEADER = "PublicKeyPEMFile";
    private static final String PRIVATE_KEY_PEM_FILE_HEADER = "PrivateKeyPEMFile";

    public ISslCertificate getDefaultSSLCertificatefromLocalNolixConfiguration() {
        INode<?> localNolixConfiguration = this.getNolixConfiguration();
        return this.getDefaultSSLCertificateFromNolixConfiguration(localNolixConfiguration);
    }

    public String getDefaultDomainFromLocalNolixConfiguration() {
        INode<?> localNolixConfiguration = this.getNolixConfiguration();
        return this.getDefaultDomainFromNolixConfiguration(localNolixConfiguration);
    }

    private String getDefaultDomainFromDefaultCertificateConfiguration(INode<?> defaultSSLCertificateConfiguration) {
        return defaultSSLCertificateConfiguration.getStoredFirstChildNodeWithHeader(DOMAIN_HEADER).getSingleChildNodeHeader();
    }

    private String getDefaultDomainFromNolixConfiguration(INode<?> nolixConfiguration) {
        Object defaultSSLCertificateConfiguration = nolixConfiguration.getStoredFirstChildNodeWithHeader(DEFAULT_SSL_CERTIFICATE_HEADER);
        return this.getDefaultDomainFromDefaultCertificateConfiguration((INode<?>)defaultSSLCertificateConfiguration);
    }

    private ISslCertificate getDefaultSSLCertificateFromDefaultCertificateConfiguration(INode<?> defaultSSLCertificateConfiguration) {
        String publicKeyPemFilePath = defaultSSLCertificateConfiguration.getStoredFirstChildNodeWithHeader(PUBLIC_KEY_PEM_FILE_HEADER).getSingleChildNodeHeader();
        String privateKeyPemFilePath = defaultSSLCertificateConfiguration.getStoredFirstChildNodeWithHeader(PRIVATE_KEY_PEM_FILE_HEADER).getSingleChildNodeHeader();
        return new SslCertificate(publicKeyPemFilePath, privateKeyPemFilePath);
    }

    private ISslCertificate getDefaultSSLCertificateFromNolixConfiguration(INode<?> nolixConfiguration) {
        Object defaultSSLCertificateConfiguration = nolixConfiguration.getStoredFirstChildNodeWithHeader(DEFAULT_SSL_CERTIFICATE_HEADER);
        return this.getDefaultSSLCertificateFromDefaultCertificateConfiguration((INode<?>)defaultSSLCertificateConfiguration);
    }

    private INode<?> getNolixConfiguration() {
        return Node.fromFile(NolixEnvironmentService.getNolixConfigurationFilePath());
    }
}

