/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.programcontrol.stopwatch;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;

public final class StopWatch {
    private long totalRunningTimeInMilliseconds;
    private boolean running;
    private long latestStartInMilliseconds;

    private StopWatch() {
    }

    public static StopWatch createStandingStopWatch() {
        return new StopWatch();
    }

    public static StopWatch createStartedStopWatch() {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        return stopWatch;
    }

    public synchronized long getTotalRunningTimeInMilliseconds() {
        if (this.isRunning()) {
            long durationInMilliseconds = System.currentTimeMillis() - this.latestStartInMilliseconds;
            return this.totalRunningTimeInMilliseconds + durationInMilliseconds;
        }
        return this.totalRunningTimeInMilliseconds;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void stop() {
        this.assertIsRunning();
        long durationInMilliseconds = System.currentTimeMillis() - this.latestStartInMilliseconds;
        this.totalRunningTimeInMilliseconds += durationInMilliseconds;
        this.running = false;
    }

    public synchronized long stopAndGetMillisecondsSinceLatestStart() {
        this.assertIsRunning();
        long durationInMilliseconds = System.currentTimeMillis() - this.latestStartInMilliseconds;
        this.totalRunningTimeInMilliseconds += durationInMilliseconds;
        this.running = false;
        return durationInMilliseconds;
    }

    public synchronized long stopAndGetTotalRunningTimeInMilliseconds() {
        this.assertIsRunning();
        long durationInMilliseconds = System.currentTimeMillis() - this.latestStartInMilliseconds;
        this.totalRunningTimeInMilliseconds += durationInMilliseconds;
        this.running = false;
        return this.totalRunningTimeInMilliseconds;
    }

    public synchronized void start() {
        this.assertIsNotRunning();
        this.latestStartInMilliseconds = System.currentTimeMillis();
        this.running = true;
    }

    private void assertIsNotRunning() {
        if (this.isRunning()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is started");
        }
    }

    private void assertIsRunning() {
        if (!this.isRunning()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "is not started");
        }
    }
}

