/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.reflection.reflectiontool;

import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.reflection.reflectionexaminer.FieldExaminer;
import ch.nolix.coreapi.reflection.reflectionexaminer.IFieldExaminer;
import java.lang.reflect.Field;

public final class FieldTool {
    private static final IFieldExaminer FIELD_EXAMINER = new FieldExaminer();

    public <V> V getValueFromStaticField(Field paramField) {
        if (!FIELD_EXAMINER.isStatic(paramField)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(paramField, "is not ");
        }
        try {
            paramField.setAccessible(true);
            return (V)paramField.get(null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrapperException.forError(illegalAccessException);
        }
    }

    public boolean hasGivenTypeOrSuperType(Field field, Class<?> type) {
        return type.isAssignableFrom(field.getType());
    }

    public boolean isStaticAndStoresValueOfGivenType(Field field, Class<?> type) {
        if (type == null) {
            throw ArgumentIsNullException.forArgumentName("type");
        }
        if (!FIELD_EXAMINER.isStatic(field)) {
            return false;
        }
        Object value = this.getValueFromStaticField(field);
        return value != null && type.isAssignableFrom(value.getClass());
    }
}

