/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.reflection.reflectiontool;

import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.validator.Validator;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;

public final class ObjectTool {
    public Field getFirstFieldOfObjectThatStoresValue(Object object, Object value) {
        Validator.assertThat(value).thatIsNamed("value").isNotNull();
        Class<?> localClass = object.getClass();
        while (localClass != null) {
            Field[] fieldArray = localClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                Object fieldValue = this.getValueOfFieldOfObject(object, f);
                if (fieldValue == value) {
                    return f;
                }
                ++n2;
            }
            localClass = localClass.getSuperclass();
        }
        throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeType(object, value.getClass());
    }

    public String getNameOfFirstFieldOfObjectThatStoresValue(Object object, Object value) {
        Field field = this.getFirstFieldOfObjectThatStoresValue(object, value);
        return field.getName();
    }

    public Object getValueOfFieldOfObject(Object object, Field field) {
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (IllegalAccessException exception) {
            throw WrapperException.forError(exception);
        }
    }

    public <A extends Annotation> boolean hasAnnotation(AnnotatedElement object, Class<A> annotationType) {
        return object.getAnnotation(annotationType) != null;
    }
}

