/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.reflection.reflectiontool;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentDoesNotHaveAttributeException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.reflection.reflectionexaminer.ExecutableExaminer;
import ch.nolix.core.reflection.reflectionexaminer.FieldExaminer;
import ch.nolix.core.reflection.reflectionexaminer.MemberExaminer;
import ch.nolix.core.reflection.reflectiontool.ClassTool;
import ch.nolix.core.reflection.reflectiontool.FieldTool;
import ch.nolix.core.reflection.reflectiontool.ObjectTool;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.reflection.reflectionexaminer.IFieldExaminer;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;

public final class ReflectionTool {
    private static final ClassTool CLASS_TOOL = new ClassTool();
    private static final MemberExaminer MEMBER_EXAMINER = new MemberExaminer();
    private static final IFieldExaminer FIELD_EXAMINER = new FieldExaminer();
    private static final FieldTool FIELD_TOOL = new FieldTool();
    private static final ExecutableExaminer EXECUTABLE_TOOL = new ExecutableExaminer();
    private static final ObjectTool OBJECT_TOOL = new ObjectTool();

    private ReflectionTool() {
    }

    public static boolean allParametersOfMethodAreOfType(Executable executable, Class<?> type) {
        return EXECUTABLE_TOOL.allParametersOfExecutableAreOfType(executable, type);
    }

    public static <T> T createInstanceFromDefaultConstructorOfClass(Class<T> paramClass) {
        return CLASS_TOOL.createInstanceFromDefaultConstructorOfClass(paramClass);
    }

    public static <T> Constructor<T> getDefaultConstructorOfClass(Class<T> paramClass) {
        return CLASS_TOOL.getDefaultConstructorOfClass(paramClass);
    }

    public static Field getFirstFieldOfObjectThatStoresValue(Object object, Object value) {
        Validator.assertThat(value).thatIsNamed("value").isNotNull();
        Class<?> localClass = object.getClass();
        while (localClass != null) {
            Field[] fieldArray = localClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                Object fieldValue = ReflectionTool.getValueOfFieldOfObject(object, f);
                if (fieldValue == value) {
                    return f;
                }
                ++n2;
            }
            localClass = localClass.getSuperclass();
        }
        throw ArgumentDoesNotHaveAttributeException.forArgumentAndAttributeType(object, value.getClass());
    }

    public static String getNameOfFirstFieldOfObjectThatStoresValue(Object object, Object value) {
        return OBJECT_TOOL.getNameOfFirstFieldOfObjectThatStoresValue(object, value);
    }

    public static IContainer<Object> getStoredPublicStaticFieldValuesOfClass(Class<?> paramClass) {
        return CLASS_TOOL.getStoredPublicStaticFieldValuesOfClass(paramClass);
    }

    public static <V> V getValueFromStaticField(Field staticField) {
        return FIELD_TOOL.getValueFromStaticField(staticField);
    }

    public static Object getValueOfFieldOfObject(Object object, Field field) {
        return OBJECT_TOOL.getValueOfFieldOfObject(object, field);
    }

    public static <A extends Annotation> boolean hasAnnotation(AnnotatedElement object, Class<A> annotationType) {
        return OBJECT_TOOL.hasAnnotation(object, annotationType);
    }

    public static boolean hasGivenTypeOrSuperType(Field field, Class<?> type) {
        return FIELD_TOOL.hasGivenTypeOrSuperType(field, type);
    }

    public static boolean isPrivate(Member member) {
        return MEMBER_EXAMINER.isPrivate(member);
    }

    public static boolean isProtected(Member member) {
        return MEMBER_EXAMINER.isProtected(member);
    }

    public static boolean isPublic(Member member) {
        return MEMBER_EXAMINER.isPublic(member);
    }

    public static boolean isStatic(Field field) {
        return FIELD_EXAMINER.isStatic(field);
    }

    public static boolean isStaticAndStoresValueOfGivenType(Field field, Class<?> type) {
        return FIELD_TOOL.isStaticAndStoresValueOfGivenType(field, type);
    }
}

