/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.core.web.css;

import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentIsNullException;
import ch.nolix.coreapi.web.css.ICssProperty;

public final class CssProperty
implements ICssProperty {
    private final String name;
    private final String value;

    private CssProperty(String name, String value) {
        if (name == null) {
            throw ArgumentIsNullException.forArgumentName("name");
        }
        if (value == null) {
            throw ArgumentIsNullException.forArgumentName("value");
        }
        this.name = name;
        this.value = value;
    }

    public static CssProperty fromCssProperty(ICssProperty cssProperty) {
        if (cssProperty instanceof CssProperty) {
            CssProperty localCssProperty = (CssProperty)cssProperty;
            return localCssProperty;
        }
        return CssProperty.withNameAndValue(cssProperty.getName(), cssProperty.getValue());
    }

    public static CssProperty withNameAndValue(String name, double value) {
        return new CssProperty(name, String.valueOf(value));
    }

    public static CssProperty withNameAndValue(String name, Enum<?> value) {
        return new CssProperty(name, value.toString());
    }

    public static CssProperty withNameAndValue(String name, int value) {
        return new CssProperty(name, String.valueOf(value));
    }

    public static CssProperty withNameAndValue(String name, String value) {
        return new CssProperty(name, value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    public String toString() {
        return this.getName() + ": " + this.getValue() + ";";
    }
}

