/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.element.property;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.attribute.mandatoryattribute.INameHolder;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.coreapi.state.staterequest.MutabilityRequestable;
import ch.nolix.systemapi.element.property.IBaseValue;
import java.util.function.Function;

public abstract class AbstractValue<V>
implements IBaseValue,
MutabilityRequestable,
INameHolder {
    private final String name;
    private final Function<INode<?>, V> valueCreator;
    protected final Function<V, INode<?>> specificationCreator;

    AbstractValue(String name, Function<INode<?>, V> valueCreator, Function<V, INode<?>> specificationCreator) {
        Validator.assertThat(name).thatIsNamed("name").isNotBlank();
        Validator.assertThat(valueCreator).thatIsNamed("value creator").isNotNull();
        Validator.assertThat(specificationCreator).thatIsNamed("specificaiton creator").isNotNull();
        this.name = name;
        this.valueCreator = valueCreator;
        this.specificationCreator = specificationCreator;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final boolean addedOrChangedAttribute(INode<?> attribute) {
        if (attribute.hasHeader(this.getName())) {
            this.addOrChangeValue(this.valueCreator.apply(attribute));
            return true;
        }
        return false;
    }

    protected abstract void addOrChangeValue(V var1);
}

