/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.nodemiddata.datareader;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.IMutableNode;
import ch.nolix.system.middata.valuemapper.ValueMapper;
import ch.nolix.system.nodemiddata.modelmapper.EntityLoadingDtoMapper;
import ch.nolix.system.nodemiddata.nodeexaminer.TableNodeExaminer;
import ch.nolix.system.nodemiddata.nodesearcher.TableNodeSearcher;
import ch.nolix.system.nodemidschema.nodesearcher.DatabaseNodeSearcher;
import ch.nolix.system.nodemidschema.nodesearcher.DatabasePropertiesNodeSearcher;
import ch.nolix.systemapi.middata.model.EntityLoadingDto;
import ch.nolix.systemapi.middata.model.MultiReferenceEntryDto;
import ch.nolix.systemapi.middata.valuemapper.IValueMapper;
import ch.nolix.systemapi.midschemaview.model.ColumnViewDto;
import ch.nolix.systemapi.midschemaview.model.TableViewDto;
import ch.nolix.systemapi.nodemiddata.nodeexaminer.ITableNodeExaminer;
import ch.nolix.systemapi.nodemiddata.nodesearcher.ITableNodeSearcher;
import ch.nolix.systemapi.nodemidschema.nodesearcher.IDatabaseNodeSearcher;
import ch.nolix.systemapi.nodemidschema.nodesearcher.IDatabasePropertiesNodeSearcher;
import ch.nolix.systemapi.time.moment.ITime;

public final class InternalDataReader {
    private static final IDatabaseNodeSearcher DATABASE_NODE_SEARCHER = new DatabaseNodeSearcher();
    private static final IDatabasePropertiesNodeSearcher DATABASE_PROPERTIES_NODE_SEARCHER = new DatabasePropertiesNodeSearcher();
    private static final ITableNodeSearcher TABLE_NODE_SEARCHER = new TableNodeSearcher();
    private static final ITableNodeExaminer TABLE_NODE_EXAMINER = new TableNodeExaminer();
    private static final EntityLoadingDtoMapper ENTITY_LOADING_DTO_MAPPER = new EntityLoadingDtoMapper();
    private static final IValueMapper VALUE_MAPPER = new ValueMapper();
    private final IMutableNode<?> nodeDatabase;

    public InternalDataReader(IMutableNode<?> nodeDatabase) {
        Validator.assertThat(nodeDatabase).thatIsNamed("database node").isNotNull();
        this.nodeDatabase = nodeDatabase;
    }

    public String getDatabaseName() {
        return DATABASE_NODE_SEARCHER.getDatabaseNameFromNodeDatabase(this.nodeDatabase);
    }

    public ITime getSchemaTimestamp() {
        IMutableNode<?> databasePropertiesNode = DATABASE_NODE_SEARCHER.getStoredDatabasePropertiesNodeFromNodeDatabase(this.nodeDatabase);
        return DATABASE_PROPERTIES_NODE_SEARCHER.getSchemaTimestampFromDatabasePropertiesNode(databasePropertiesNode);
    }

    public IContainer<EntityLoadingDto> loadEntitiesOfTable(TableViewDto tableView) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(this.nodeDatabase, tableView.name());
        return TABLE_NODE_SEARCHER.getStoredEntityNodesFromTableNode(tableNode).to(rn -> ENTITY_LOADING_DTO_MAPPER.mapEntityNodeToEntityLoadingDto((IMutableNode<?>)rn, tableView));
    }

    public IContainer<String> loadMultiBackReferenceBackReferencedEntityIds(String tableName, String entityId, ColumnViewDto multiBackReferenceColumnInfo) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(this.nodeDatabase, tableName);
        IMutableNode<?> entityNode = TABLE_NODE_SEARCHER.getStoredEntityNodeFromTableNode(tableNode, entityId);
        int multiBackReferenceColumnOneBasedOrdinalIndex = multiBackReferenceColumnInfo.oneBasedOrdinalIndex();
        IMutableNode multiBackReferenceNode = (IMutableNode)entityNode.getStoredChildNodeAtOneBasedIndex(multiBackReferenceColumnOneBasedOrdinalIndex);
        IContainer multiBackReferenceBackReferencedEntityNodes = multiBackReferenceNode.getStoredChildNodes();
        return multiBackReferenceBackReferencedEntityNodes.to(b -> ((IMutableNode)b.getStoredFirstChildNode()).getHeader());
    }

    public IContainer<MultiReferenceEntryDto> loadMultiReferenceEntries(String tableName, String entityId, ColumnViewDto multiReferenceColumnView) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(this.nodeDatabase, tableName);
        IMutableNode<?> entityNode = TABLE_NODE_SEARCHER.getStoredEntityNodeFromTableNode(tableNode, entityId);
        int multiReferenceColumnOneBasedOrdinalIndex = multiReferenceColumnView.oneBasedOrdinalIndex();
        String multiReferenceColumnId = multiReferenceColumnView.id();
        IMutableNode multiReferenceNode = (IMutableNode)entityNode.getStoredChildNodeAtOneBasedIndex(multiReferenceColumnOneBasedOrdinalIndex);
        IContainer multiReferenceEntryNodes = multiReferenceNode.getStoredChildNodes();
        return multiReferenceEntryNodes.to(n -> new MultiReferenceEntryDto(tableName, entityId, multiReferenceColumnId, ((IMutableNode)n.getStoredChildNodeAtOneBasedIndex(1)).getHeader(), ((IMutableNode)n.getStoredChildNodeAtOneBasedIndex(2)).getHeader()));
    }

    public IContainer<Object> loadMultiValueEntries(String tableName, String entityId, ColumnViewDto multiValueColumnInfo) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(this.nodeDatabase, tableName);
        IMutableNode<?> entityNode = TABLE_NODE_SEARCHER.getStoredEntityNodeFromTableNode(tableNode, entityId);
        int multiValueColumnOneBasedOrdinalIndex = multiValueColumnInfo.oneBasedOrdinalIndex();
        IMutableNode multiValueNode = (IMutableNode)entityNode.getStoredChildNodeAtOneBasedIndex(multiValueColumnOneBasedOrdinalIndex);
        return multiValueNode.getStoredChildNodes().to(a -> VALUE_MAPPER.mapStringToValue(a.getHeader(), multiValueColumnInfo.dataType()));
    }

    public EntityLoadingDto loadEntity(TableViewDto tableView, String id) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(this.nodeDatabase, tableView.name());
        IMutableNode<?> entityNode = TABLE_NODE_SEARCHER.getStoredEntityNodeFromTableNode(tableNode, id);
        return ENTITY_LOADING_DTO_MAPPER.mapEntityNodeToEntityLoadingDto(entityNode, tableView);
    }

    public boolean tableContainsEntityWithGivenValueAtGivenColumn(String tableName, ColumnViewDto columnInfo, String value) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(this.nodeDatabase, tableName);
        int columnOneBasedOrdinalIndex = columnInfo.oneBasedOrdinalIndex();
        return TABLE_NODE_EXAMINER.tableNodeContainsEntityNodeWhoseFieldAtGivenIndexContainsGivenValue(tableNode, columnOneBasedOrdinalIndex, value);
    }

    public boolean tableContainsEntityWithGivenValueAtGivenColumnIgnoringGivenEntities(String tableName, ColumnViewDto columnInfo, String value, IContainer<String> entitiesToIgnoreIds) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(this.nodeDatabase, tableName);
        int columnOneBasedOrdinalIndex = columnInfo.oneBasedOrdinalIndex();
        return TABLE_NODE_EXAMINER.tableNodeContainsEntityNodeWithFieldAtGivenOneBasedIndexWithGivenValueIgnoringGivenEntities(tableNode, columnOneBasedOrdinalIndex, value, entitiesToIgnoreIds);
    }

    public boolean tableContainsEntityWithGivenId(String tableName, String id) {
        IMutableNode<?> tableNode = DATABASE_NODE_SEARCHER.getStoredTableNodeByTableNameFromNodeDatabase(this.nodeDatabase, tableName);
        return TABLE_NODE_EXAMINER.tableNodeContainsEntityNodeWithGivenId(tableNode, id);
    }
}

