/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.nodemiddata.modelmapper;

import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.document.node.IMutableNode;
import ch.nolix.coreapi.document.node.INode;
import ch.nolix.system.middata.valuemapper.ValueMapper;
import ch.nolix.systemapi.middata.model.ObjectValueFieldDto;
import ch.nolix.systemapi.middata.valuemapper.IValueMapper;
import ch.nolix.systemapi.midschemaview.model.ColumnViewDto;
import ch.nolix.systemapi.midschemaview.model.TableViewDto;
import ch.nolix.systemapi.nodemiddata.modelmapper.IContentFieldDtoMapper;

public final class ContentFieldDtoMapper
implements IContentFieldDtoMapper {
    private static final IValueMapper VALUE_MAPPER = new ValueMapper();

    @Override
    public ObjectValueFieldDto mapContentFieldNodeToContentFieldDto(INode<?> contentFieldNode, ColumnViewDto columnInfo) {
        if (contentFieldNode.containsChildNodes()) {
            return new ObjectValueFieldDto(columnInfo.name(), null);
        }
        if (!contentFieldNode.hasHeader()) {
            return new ObjectValueFieldDto(columnInfo.name(), null);
        }
        return new ObjectValueFieldDto(columnInfo.name(), VALUE_MAPPER.mapStringToValue(contentFieldNode.getHeader(), columnInfo.dataType()));
    }

    @Override
    public IContainer<ObjectValueFieldDto> mapEntityNodeToContentFieldDtos(IMutableNode<?> entityNode, TableViewDto tableView) {
        LinkedList<ObjectValueFieldDto> contentFields = LinkedList.createEmpty();
        for (ColumnViewDto c : tableView.columnViews()) {
            IMutableNode contentFieldNode = (IMutableNode)entityNode.getStoredChildNodeAtOneBasedIndex(c.oneBasedOrdinalIndex());
            ObjectValueFieldDto contentFieldDto = this.mapContentFieldNodeToContentFieldDto(contentFieldNode, c);
            contentFields.addAtEnd(contentFieldDto);
        }
        return contentFields;
    }
}

