/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.nodemidschema.modelmapper;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.coreapi.document.node.IMutableNode;
import ch.nolix.system.nodemidschema.nodesearcher.ContentModelNodeSearcher;
import ch.nolix.systemapi.midschema.fieldproperty.ContentType;
import ch.nolix.systemapi.midschema.model.BackReferenceModelDto;
import ch.nolix.systemapi.midschema.model.IContentModelDto;
import ch.nolix.systemapi.midschema.model.MultiBackReferenceModelDto;
import ch.nolix.systemapi.midschema.model.MultiReferenceModelDto;
import ch.nolix.systemapi.midschema.model.MultiValueModelDto;
import ch.nolix.systemapi.midschema.model.OptionalBackReferenceModelDto;
import ch.nolix.systemapi.midschema.model.OptionalReferenceModelDto;
import ch.nolix.systemapi.midschema.model.OptionalValueModelDto;
import ch.nolix.systemapi.midschema.model.ReferenceModelDto;
import ch.nolix.systemapi.midschema.model.ValueModelDto;
import ch.nolix.systemapi.nodemidschema.modelmapper.IContentModelDtoMapper;
import ch.nolix.systemapi.nodemidschema.nodesearcher.IContentModelNodeSearcher;

public final class ContentModelDtoMapper
implements IContentModelDtoMapper {
    private static final IContentModelNodeSearcher CONTENT_MODEL_NODE_SEARCHER = new ContentModelNodeSearcher();

    @Override
    public IContentModelDto mapContentModelNodeToContentModelDto(IMutableNode<?> contentModelNode) {
        ContentType contentType = CONTENT_MODEL_NODE_SEARCHER.getContentTypeFromContentModelNode(contentModelNode);
        return switch (contentType) {
            case ContentType.VALUE -> new ValueModelDto(CONTENT_MODEL_NODE_SEARCHER.getDataTypeFromContentModelNode(contentModelNode));
            case ContentType.OPTIONAL_VALUE -> new OptionalValueModelDto(CONTENT_MODEL_NODE_SEARCHER.getDataTypeFromContentModelNode(contentModelNode));
            case ContentType.MULTI_VALUE -> new MultiValueModelDto(CONTENT_MODEL_NODE_SEARCHER.getDataTypeFromContentModelNode(contentModelNode));
            case ContentType.REFERENCE -> new ReferenceModelDto(CONTENT_MODEL_NODE_SEARCHER.getDataTypeFromContentModelNode(contentModelNode), CONTENT_MODEL_NODE_SEARCHER.getReferencedTableIdFromContentModelNode(contentModelNode));
            case ContentType.OPTIONAL_REFERENCE -> new OptionalReferenceModelDto(CONTENT_MODEL_NODE_SEARCHER.getDataTypeFromContentModelNode(contentModelNode), CONTENT_MODEL_NODE_SEARCHER.getReferencedTableIdFromContentModelNode(contentModelNode));
            case ContentType.MULTI_REFERENCE -> new MultiReferenceModelDto(CONTENT_MODEL_NODE_SEARCHER.getDataTypeFromContentModelNode(contentModelNode), CONTENT_MODEL_NODE_SEARCHER.getReferencedTableIdFromContentModelNode(contentModelNode));
            case ContentType.BACK_REFERENCE -> new BackReferenceModelDto(CONTENT_MODEL_NODE_SEARCHER.getDataTypeFromContentModelNode(contentModelNode), CONTENT_MODEL_NODE_SEARCHER.getBackReferencedColumnIdFromContentModelNode(contentModelNode));
            case ContentType.OPTIONAL_BACK_REFERENCE -> new OptionalBackReferenceModelDto(CONTENT_MODEL_NODE_SEARCHER.getDataTypeFromContentModelNode(contentModelNode), CONTENT_MODEL_NODE_SEARCHER.getBackReferencedColumnIdFromContentModelNode(contentModelNode));
            case ContentType.MULTI_BACK_REFERENCE -> new MultiBackReferenceModelDto(CONTENT_MODEL_NODE_SEARCHER.getDataTypeFromContentModelNode(contentModelNode), CONTENT_MODEL_NODE_SEARCHER.getBackReferencedColumnIdFromContentModelNode(contentModelNode));
            default -> throw InvalidArgumentException.forArgument((Object)contentType);
        };
    }
}

