/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.changesetsaver;

import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.changesetsaver.ChangeSetSaveValidator;
import ch.nolix.system.objectdata.changesetsaver.EntitySaver;
import ch.nolix.system.objectdata.datavalidator.DatabaseValidator;
import ch.nolix.system.objectdata.modelsearcher.DatabaseSearcher;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.objectdata.model.IDatabase;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.modelsearcher.IDatabaseSearcher;

public final class ChangeSetSaver {
    private static final IDatabaseSearcher DATABASE_TOOL = new DatabaseSearcher();
    private static final DatabaseValidator DATABASE_VALIDATOR = new DatabaseValidator();
    private static final ChangeSetSaveValidator DATABASE_SAVE_VALIDATOR = new ChangeSetSaveValidator();
    private static final EntitySaver ENTITY_SAVER = new EntitySaver();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveChangesOfDatabaseSynchronously(IDatabase database, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        Class<ChangeSetSaver> clazz = ChangeSetSaver.class;
        synchronized (ChangeSetSaver.class) {
            this.saveChangesOfDatabase(database, dataAndSchemaAdapter);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void saveChangesOfDatabase(IDatabase database, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        this.assertCanSaveChangesOfDatabase(database);
        this.addExpectionThatDatabaseHasInitialSchemaTimestamp(database, dataAndSchemaAdapter);
        this.prepareChangesOfDatabase(database, dataAndSchemaAdapter);
        this.assertNewlyReferencedEntitiesExists(database, dataAndSchemaAdapter);
        this.commitChangesToDatabase(dataAndSchemaAdapter);
    }

    private void assertCanSaveChangesOfDatabase(IDatabase database) {
        DATABASE_VALIDATOR.assertCanSaveChanges(database);
    }

    private void prepareChangesOfDatabase(IDatabase database, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        IContainer<IEntity> entitiesInLocalData = DATABASE_TOOL.getStoredEntitiesInLocalData(database);
        for (IEntity e : entitiesInLocalData) {
            ENTITY_SAVER.saveChangesOfEntity(e, dataAndSchemaAdapter);
        }
    }

    private void addExpectionThatDatabaseHasInitialSchemaTimestamp(IDatabase database, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        dataAndSchemaAdapter.expectSchemaTimestamp(database.getSchemaTimestamp());
    }

    private void assertNewlyReferencedEntitiesExists(IDatabase database, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        DATABASE_SAVE_VALIDATOR.addExpectationToDatabaseThatNewlyReferencedEntitiesExist(database, dataAndSchemaAdapter);
    }

    private void commitChangesToDatabase(IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        dataAndSchemaAdapter.saveChanges();
    }
}

