/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.changesetsaver;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.system.objectdata.middatamodelmapper.MultiValueEntryDtoMapper;
import ch.nolix.systemapi.databaseobject.databaseobjectproperty.DatabaseObjectState;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.middata.model.MultiValueEntryDto;
import ch.nolix.systemapi.objectdata.middatamodelmapper.IMultiValueEntryDtoMapper;
import ch.nolix.systemapi.objectdata.model.IMultiValueField;
import ch.nolix.systemapi.objectdata.model.IMultiValueFieldEntry;

public final class MultiValueSaver {
    private static final IMultiValueEntryDtoMapper MULTI_VALUE_ENTRY_DTO_MAPPER = new MultiValueEntryDtoMapper();

    public void saveChangesOfMultiValue(IMultiValueField<?> multiValue, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        for (IMultiValueFieldEntry iMultiValueFieldEntry : multiValue.getStoredNewAndDeletedEntries()) {
            this.saveChangeOfMultiValueEntry(iMultiValueFieldEntry, dataAndSchemaAdapter);
        }
    }

    private void saveChangeOfMultiValueEntry(IMultiValueFieldEntry<?> multiValueEntry, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        DatabaseObjectState multiValueEntryState = (DatabaseObjectState)((Object)multiValueEntry.getState());
        switch (multiValueEntryState) {
            case NEW: {
                this.saveMultiValueEntryCreation(multiValueEntry, dataAndSchemaAdapter);
                break;
            }
            case DELETED: {
                this.saveMultiValueEntryDeletion(multiValueEntry, dataAndSchemaAdapter);
                break;
            }
            default: {
                throw InvalidArgumentException.forArgumentAndArgumentName((Object)multiValueEntryState, "state of multi value");
            }
        }
    }

    private void saveMultiValueEntryCreation(IMultiValueFieldEntry<?> multiValueEntry, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        MultiValueEntryDto multiValueEntryDto = MULTI_VALUE_ENTRY_DTO_MAPPER.mapMultiValueEntryToMultiValueEntryDto(multiValueEntry);
        dataAndSchemaAdapter.insertMultiValueEntry(multiValueEntryDto);
    }

    private void saveMultiValueEntryDeletion(IMultiValueFieldEntry<?> multiValueEntry, IDataAdapterAndSchemaReader dataAndSchemaAdapter) {
        MultiValueEntryDto multiValueEntryDto = MULTI_VALUE_ENTRY_DTO_MAPPER.mapMultiValueEntryToMultiValueEntryDto(multiValueEntry);
        dataAndSchemaAdapter.deleteMultiValueEntry(multiValueEntryDto);
    }
}

