/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.fieldtool;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.reflection.reflectiontool.ReflectionTool;
import ch.nolix.system.databaseobject.modelexaminer.DatabaseObjectExaminer;
import ch.nolix.systemapi.midschema.fieldproperty.BaseContentType;
import ch.nolix.systemapi.midschema.fieldproperty.ContentType;
import ch.nolix.systemapi.objectdata.fieldtool.IFieldTool;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IMultiValueField;
import ch.nolix.systemapi.objectdata.model.IOptionalValueField;
import ch.nolix.systemapi.objectdata.model.IValueField;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class FieldTool
extends DatabaseObjectExaminer
implements IFieldTool {
    @Override
    public final Class<?> getDataType(IField field) {
        return switch (field.getType().getBaseType()) {
            case BaseContentType.BASE_VALUE -> this.getDataTypeWhenIsBaseValue(field);
            case BaseContentType.BASE_REFERENCE, BaseContentType.BASE_BACK_REFERENCE -> String.class;
            default -> throw InvalidArgumentException.forArgument(field);
        };
    }

    private Class<?> getDataTypeWhenDoesNotBelongToEntity(IMultiValueField<?> multiValue) {
        if (multiValue.isEmpty()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(multiValue, "cannot know its data type");
        }
        return multiValue.getAllStoredValues().getStoredFirst().getClass();
    }

    private Class<?> getDataTypeWhenDoesNotBelongToEntity(IOptionalValueField<?> optionalValue) {
        if (optionalValue.isEmpty()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(optionalValue, "cannot know its data type");
        }
        return optionalValue.getStoredValue().getClass();
    }

    private Class<?> getDataTypeWhenDoesNotBelongToEntity(IValueField<?> value) {
        if (value.isEmpty()) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(value, "cannot know its data type");
        }
        return value.getStoredValue().getClass();
    }

    private Class<?> getDataTypeWhenIsBaseValue(IField field) {
        if (!field.belongsToEntity()) {
            return this.getDataTypeWhenIsBaseValueAndDoesNotBelongToEntity(field);
        }
        return this.getDataTypeWhenIsBaseValueAndBelongsToEntity(field);
    }

    private Class<?> getDataTypeWhenIsBaseValueAndBelongsToEntity(IField field) {
        IEntity fieldParentEntity = (IEntity)field.getStoredParentEntity();
        Field entityField = ReflectionTool.getFirstFieldOfObjectThatStoresValue(fieldParentEntity, field);
        ParameterizedType fieldDeclaredType = (ParameterizedType)entityField.getGenericType();
        Type[] typeArguments = fieldDeclaredType.getActualTypeArguments();
        return (Class)typeArguments[typeArguments.length - 1];
    }

    private Class<?> getDataTypeWhenIsBaseValueAndDoesNotBelongToEntity(IField field) {
        return switch (field.getType()) {
            case ContentType.VALUE -> this.getDataTypeWhenDoesNotBelongToEntity((IValueField)field);
            case ContentType.OPTIONAL_VALUE -> this.getDataTypeWhenDoesNotBelongToEntity((IOptionalValueField)field);
            case ContentType.MULTI_VALUE -> this.getDataTypeWhenDoesNotBelongToEntity((IMultiValueField)field);
            default -> throw InvalidArgumentException.forArgumentAndErrorPredicate(field, "is not a base value");
        };
    }
}

