/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.fieldtool;

import ch.nolix.system.objectdata.fieldtool.FieldTool;
import ch.nolix.systemapi.databaseobject.model.IDatabaseObject;
import ch.nolix.systemapi.objectdata.fieldtool.IReferenceTool;
import ch.nolix.systemapi.objectdata.model.IAbstractBackReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IReference;
import java.util.Optional;

public final class ReferenceTool
extends FieldTool
implements IReferenceTool {
    @Override
    public Optional<IAbstractBackReference<IEntity>> getOptionalStoredBaseBackReferenceForReference(IReference<IEntity> reference) {
        if (reference.isEmpty()) {
            return Optional.empty();
        }
        return this.getOptionalStoredBaseBackReferenceOfReferenceWhenContainsAny(reference);
    }

    @Override
    public boolean toReferenceCanSetEntity(IReference<?> reference, IEntity entity) {
        return this.canSetEntity(reference) && this.isOpen(reference) && reference.getReferencedTableName().equals(entity.getParentTableName()) && !reference.referencesEntity(entity);
    }

    private boolean canSetEntity(IReference<?> reference) {
        return this.isOpen(reference) && reference.belongsToEntity();
    }

    private Optional<IAbstractBackReference<IEntity>> getOptionalStoredBaseBackReferenceOfReferenceWhenContainsAny(IReference<IEntity> reference) {
        IEntity referencedEntity = reference.getStoredReferencedEntity();
        Optional<IField> backReference = referencedEntity.internalGetStoredFields().getOptionalStoredFirst(p -> p.referencesBackField(reference));
        return backReference.map(br -> (IAbstractBackReference)br);
    }

    private boolean isOpen(IDatabaseObject databaseObject) {
        return databaseObject != null && databaseObject.isOpen();
    }
}

