/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.fieldvalidator;

import ch.nolix.core.errorcontrol.invalidargumentexception.EmptyArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.system.objectdata.fieldtool.OptionalReferenceTool;
import ch.nolix.system.objectdata.fieldvalidator.FieldValidator;
import ch.nolix.systemapi.objectdata.fieldtool.IOptionalReferenceTool;
import ch.nolix.systemapi.objectdata.fieldvalidator.IOptionalReferenceValidator;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IOptionalReference;

public final class OptionalReferenceValidator
extends FieldValidator
implements IOptionalReferenceValidator {
    private static final IOptionalReferenceTool OPTIONAL_REFERENCE_TOOL = new OptionalReferenceTool();

    @Override
    public void assertCanClear(IOptionalReference<?> optionalReference) {
        if (!OPTIONAL_REFERENCE_TOOL.canClear(optionalReference)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(optionalReference, "cannot clear");
        }
    }

    @Override
    public void assertCanSetGivenEntity(IOptionalReference<?> optionalReference, IEntity entity) {
        if (!OPTIONAL_REFERENCE_TOOL.canSetEntity(optionalReference, entity)) {
            throw InvalidArgumentException.forArgumentAndErrorPredicate(optionalReference, "does not reference an entity");
        }
    }

    @Override
    public void assertIsNotEmpty(IOptionalReference<?> optionalReference) {
        if (optionalReference.isEmpty()) {
            throw EmptyArgumentException.forArgument(optionalReference);
        }
    }
}

