/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.middatamodelmapper;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.systemapi.middata.model.StringValueFieldDto;
import ch.nolix.systemapi.objectdata.middatamodelmapper.IStringContentFieldDtoMapper;
import ch.nolix.systemapi.objectdata.model.IBackReference;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.IMultiBackReference;
import ch.nolix.systemapi.objectdata.model.IMultiReference;
import ch.nolix.systemapi.objectdata.model.IMultiValueField;
import ch.nolix.systemapi.objectdata.model.IOptionalBackReference;
import ch.nolix.systemapi.objectdata.model.IOptionalReference;
import ch.nolix.systemapi.objectdata.model.IOptionalValueField;
import ch.nolix.systemapi.objectdata.model.IReference;
import ch.nolix.systemapi.objectdata.model.IValueField;

public final class StringContentFieldDtoMapper
implements IStringContentFieldDtoMapper {
    private static StringValueFieldDto mapOptionalValueToStringContentFieldDto(IOptionalValueField<?> optionalValue) {
        String columnName = optionalValue.getName();
        if (optionalValue.isEmpty()) {
            return new StringValueFieldDto(columnName, null);
        }
        return new StringValueFieldDto(columnName, optionalValue.getStoredValue().toString());
    }

    private static StringValueFieldDto mapOptionalReferenceToStringContentFieldDto(IOptionalReference<?> optionalReference) {
        String columnName = optionalReference.getName();
        if (optionalReference.isEmpty()) {
            return new StringValueFieldDto(columnName, null);
        }
        return new StringValueFieldDto(columnName, optionalReference.getReferencedEntityId());
    }

    private static StringValueFieldDto mapOptionalBackReferenceToStringContentFieldDto(IOptionalBackReference<?> optionalBackReference) {
        String columnName = optionalBackReference.getName();
        if (optionalBackReference.isEmpty()) {
            return new StringValueFieldDto(columnName, null);
        }
        return new StringValueFieldDto(columnName, optionalBackReference.getBackReferencedEntityId());
    }

    @Override
    public StringValueFieldDto mapFieldToStringContentFieldDto(IField field) {
        if (field instanceof IValueField) {
            IValueField value = (IValueField)field;
            return new StringValueFieldDto(value.getName(), value.getStoredValue().toString());
        }
        if (field instanceof IOptionalValueField) {
            IOptionalValueField optionalValue = (IOptionalValueField)field;
            return StringContentFieldDtoMapper.mapOptionalValueToStringContentFieldDto(optionalValue);
        }
        if (field instanceof IMultiValueField) {
            IMultiValueField multiValue = (IMultiValueField)field;
            return new StringValueFieldDto(multiValue.getName(), null);
        }
        if (field instanceof IReference) {
            IReference reference = (IReference)field;
            return new StringValueFieldDto(reference.getName(), reference.getReferencedEntityId());
        }
        if (field instanceof IOptionalReference) {
            IOptionalReference optionalReference = (IOptionalReference)field;
            return StringContentFieldDtoMapper.mapOptionalReferenceToStringContentFieldDto(optionalReference);
        }
        if (field instanceof IMultiReference) {
            IMultiReference multiReference = (IMultiReference)field;
            return new StringValueFieldDto(multiReference.getName(), null);
        }
        if (field instanceof IBackReference) {
            IBackReference backReference = (IBackReference)field;
            return new StringValueFieldDto(backReference.getName(), backReference.getBackReferencedEntityId());
        }
        if (field instanceof IOptionalBackReference) {
            IOptionalBackReference optionalBackReference = (IOptionalBackReference)field;
            return StringContentFieldDtoMapper.mapOptionalBackReferenceToStringContentFieldDto(optionalBackReference);
        }
        if (field instanceof IMultiBackReference) {
            IMultiBackReference multiBackReference = (IMultiBackReference)field;
            return new StringValueFieldDto(multiBackReference.getName(), null);
        }
        throw InvalidArgumentException.forArgument(field);
    }
}

