/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.model.AbstractField;
import ch.nolix.system.objectdata.model.Table;
import ch.nolix.system.objectdata.modelexaminer.FieldExaminer;
import ch.nolix.systemapi.objectdata.model.IAbstractBackReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.modelexaminer.IFieldExaminer;

public abstract class AbstractBackReference<E extends IEntity>
extends AbstractField
implements IAbstractBackReference<E> {
    private static final IFieldExaminer FIELD_EXAMINER = new FieldExaminer();
    private final String backReferencedTableName;
    private final String backReferencedFieldName;
    private Table<E> backReferencedTable;

    protected AbstractBackReference(String backReferencedTableName, String backReferencedFieldName) {
        Validator.assertThat(backReferencedTableName).thatIsNamed("back referenced table name").isNotBlank();
        Validator.assertThat(backReferencedFieldName).thatIsNamed("back referenced field name").isNotBlank();
        this.backReferencedTableName = backReferencedTableName;
        this.backReferencedFieldName = backReferencedFieldName;
    }

    @Override
    public final String getBackReferencedFieldName() {
        return this.backReferencedFieldName;
    }

    @Override
    public final ITable<E> getStoredBackReferencedTable() {
        this.extractBackReferencedTableIfNotExtracted();
        return this.backReferencedTable;
    }

    @Override
    public final String getBackReferencedTableId() {
        return this.getStoredBackReferencedTable().getId();
    }

    @Override
    public final String getBackReferencedTableName() {
        return this.backReferencedTableName;
    }

    @Override
    public final IContainer<IAbstractBackReference<IEntity>> getStoredAbstractBackReferencesThatReferencesBackThis() {
        return ImmutableList.createEmpty();
    }

    @Override
    public final boolean referencesEntity(IEntity entity) {
        return false;
    }

    @Override
    public final boolean referencesBackField(IField field) {
        return this.canReferenceBackFieldBecauseOfName(field) && this.referencesBackEntityWithId(((IEntity)field.getStoredParentEntity()).getId());
    }

    @Override
    public final boolean referencesUninsertedEntity() {
        return false;
    }

    @Override
    protected final void internalUpdateBackReferencingFieldsWhenIsInsertedIntoDatabase() {
    }

    private boolean canReferenceBackFieldBecauseOfName(IField field) {
        return this.belongsToEntity() && FIELD_EXAMINER.belongsToEntity(field) && this.getBackReferencedTableName().equals(((IEntity)field.getStoredParentEntity()).getParentTableName()) && this.getBackReferencedFieldName().equals(field.getName());
    }

    private boolean extractedBackReferencedTable() {
        return this.backReferencedTable != null;
    }

    private void extractBackReferencedTable() {
        this.backReferencedTable = this.loadBackReferencedTable();
    }

    private void extractBackReferencedTableIfNotExtracted() {
        if (!this.extractedBackReferencedTable()) {
            this.extractBackReferencedTable();
        }
    }

    private Table<E> loadBackReferencedTable() {
        return (Table)this.getStoredParentEntity().getStoredParentTable().getStoredParentDatabase().getStoredTableByName(this.getBackReferencedTableName());
    }
}

