/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.datamodel.id.IdCreator;
import ch.nolix.core.errorcontrol.invalidargumentexception.ArgumentBelongsToParentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.ClosedArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.DeletedArgumentException;
import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.databaseobject.modelvalidator.DatabaseObjectValidator;
import ch.nolix.system.objectdata.datavalidator.EntityValidator;
import ch.nolix.system.objectdata.model.AbstractField;
import ch.nolix.system.objectdata.model.BackReference;
import ch.nolix.system.objectdata.model.OptionalBackReference;
import ch.nolix.system.objectdata.model.Table;
import ch.nolix.system.objectdata.modelflyweight.EntityFlyWeight;
import ch.nolix.system.objectdata.modelflyweight.VoidEntityFlyWeight;
import ch.nolix.system.objectdata.modelsearcher.EntitySearcher;
import ch.nolix.systemapi.databaseobject.databaseobjectproperty.DatabaseObjectState;
import ch.nolix.systemapi.databaseobject.modelvalidator.IDatabaseObjectValidator;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.objectdata.datavalidator.IEntityValidator;
import ch.nolix.systemapi.objectdata.model.IAbstractBackReference;
import ch.nolix.systemapi.objectdata.model.IDatabase;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.modelflyweight.IEntityFlyWeight;
import ch.nolix.systemapi.objectdata.modelsearcher.IEntitySearcher;

public abstract class AbstractEntity
implements IEntity {
    private static final VoidEntityFlyWeight VOID_ENTITY_FLY_WEIGHT = new VoidEntityFlyWeight();
    private static final IDatabaseObjectValidator DATABASE_OBJECT_VALIDATOR = new DatabaseObjectValidator();
    private static final IEntitySearcher ENTITY_SEARCHER = new EntitySearcher();
    private static final IEntityValidator ENTITY_VALIDATOR = new EntityValidator();
    private ITable<? extends IEntity> parentTable;
    private String id = IdCreator.createIdOf10HexadecimalCharacters();
    private DatabaseObjectState state = DatabaseObjectState.NEW;
    private String saveStamp;
    private IEntityFlyWeight entityFlyweight = VOID_ENTITY_FLY_WEIGHT;
    private IContainer<AbstractField> fields;

    @Override
    public final boolean belongsToTable() {
        return this.parentTable != null;
    }

    @Override
    public final void delete() {
        ENTITY_VALIDATOR.assertCanBeDeleted(this);
        this.updateAbstractBackReferencesThatReferencesBackThisForDeleteThis();
        this.updateStateForDeletion();
    }

    @Override
    public final String getId() {
        return this.id;
    }

    @Override
    public final IDatabase getStoredParentDatabase() {
        return this.getStoredParentTable().getStoredParentDatabase();
    }

    @Override
    public final ITable<? extends IEntity> getStoredParentTable() {
        ENTITY_VALIDATOR.assertBelongsToTable(this);
        return this.parentTable;
    }

    @Override
    public final String getSaveStamp() {
        ENTITY_VALIDATOR.assertHasSaveStamp(this);
        return this.saveStamp;
    }

    @Override
    public final String getShortDescription() {
        return this.getClass().getSimpleName() + " (id: " + this.getId() + ")";
    }

    @Override
    public final DatabaseObjectState getState() {
        return this.state;
    }

    @Override
    public final boolean hasSaveStamp() {
        return this.saveStamp != null;
    }

    @Override
    public final IContainer<? extends IField> internalGetStoredFields() {
        return this.getStoredFields();
    }

    @Override
    public final void internalSetLoadedAndIdAndSaveStamp(String id, String saveStamp) {
        DATABASE_OBJECT_VALIDATOR.assertIsNew(this);
        Validator.assertThat(id).thatIsNamed("id").isNotBlank();
        Validator.assertThat(saveStamp).thatIsNamed("save stamp").isNotBlank();
        this.state = DatabaseObjectState.LOADED;
        this.id = id;
        this.saveStamp = saveStamp;
    }

    @Override
    public final void internalSetParentTable(ITable<? extends IEntity> parentTable) {
        Validator.assertThat(parentTable).thatIsNamed("parent table").isNotNull();
        if (this.belongsToTable()) {
            throw ArgumentBelongsToParentException.forArgumentAndParent(this, this.getStoredParentTable());
        }
        this.parentTable = parentTable;
        this.getStoredFields().forEach(AbstractField::setParentColumnFromParentTable);
    }

    @Override
    public final boolean isClosed() {
        return this.getState() == DatabaseObjectState.CLOSED;
    }

    @Override
    public final boolean isDeleted() {
        return this.getState() == DatabaseObjectState.DELETED;
    }

    @Override
    public final boolean isEdited() {
        return this.getState() == DatabaseObjectState.EDITED;
    }

    @Override
    public final boolean isConnectedWithRealDatabase() {
        return this.belongsToTable() && this.getStoredParentTable().isConnectedWithRealDatabase();
    }

    @Override
    public final boolean isLoaded() {
        return this.getState() == DatabaseObjectState.LOADED;
    }

    @Override
    public final boolean isNew() {
        return this.getState() == DatabaseObjectState.NEW;
    }

    @Override
    public final boolean isReferencedInPersistedData() {
        return this.belongsToTable() && this.isReferencedInPersistedDataWhenBelongsToTable();
    }

    @Override
    public final boolean isReferencedInPersistedDataIgnoringGivenEntities(IContainer<String> entitiesToIgnoreIds) {
        return this.belongsToTable() && this.isReferencedInPersistedDataIgnoringGivenEntitiesWhenBelongsToTable(entitiesToIgnoreIds);
    }

    public String toString() {
        return this.getShortDescription();
    }

    protected final void initialize() {
        this.extractFieldsIfNotExtracted();
    }

    protected final void setInsertAction(Runnable insertAction) {
        this.entityFlyweight = EntityFlyWeight.withInsertAction(insertAction);
    }

    final void close() {
        if (this.isOpen()) {
            this.state = DatabaseObjectState.CLOSED;
        }
    }

    abstract IContainer<AbstractField> findFields();

    final IDataAdapterAndSchemaReader getStoredMidDataAdapterAndSchemaReader() {
        return ((Table)this.getStoredParentTable()).getStoredMidDataDataAdapterAndSchemaReader();
    }

    final void noteInsertIntoDatabase() {
        this.updateBaseBackReferencesWhenIsInsertedIntoDatabase();
        this.entityFlyweight.noteInsert();
    }

    final void setEdited() {
        switch (this.getState()) {
            case NEW: {
                break;
            }
            case LOADED: {
                this.state = DatabaseObjectState.EDITED;
                break;
            }
            case EDITED: {
                break;
            }
            case DELETED: {
                throw DeletedArgumentException.forArgument(this);
            }
            case CLOSED: {
                throw ClosedArgumentException.forArgument(this);
            }
        }
    }

    private boolean extractedFields() {
        return this.fields != null;
    }

    private void extractFieldsIfNotExtracted() {
        if (!this.extractedFields()) {
            this.extractFieldsWhenNotExtracted();
        }
    }

    private void extractFieldsWhenNotExtracted() {
        this.fields = this.findFields();
        this.fields.forEach(f -> f.setParentEntity(this));
    }

    private IContainer<AbstractField> getStoredFields() {
        this.extractFieldsIfNotExtracted();
        return this.fields;
    }

    private boolean isReferencedInPersistedDataWhenBelongsToTable() {
        String localId = this.getId();
        return ((Table)this.getStoredParentTable()).internalGetColumnsThatReferencesCurrentTable().containsAny(c -> c.internalContainsGivenValueInPersistedData(localId));
    }

    private boolean isReferencedInPersistedDataIgnoringGivenEntitiesWhenBelongsToTable(IContainer<String> entitiesToIgnoreIds) {
        String localId = this.getId();
        return ((Table)this.getStoredParentTable()).internalGetColumnsThatReferencesCurrentTable().containsAny(c -> c.internalContainsGivenValueInPersistedDataIgnoringGivenEntities(localId, entitiesToIgnoreIds));
    }

    private void updateBackReferenceForDeletion(BackReference<?> backReference) {
        backReference.internalClear();
        backReference.setAsEditedAndRunPotentialUpdateAction();
    }

    private void updateAbstractBackReferencesThatReferencesBackThisForDeleteThis() {
        ENTITY_SEARCHER.getStoredAbstractBackReferencesThatReferencesBackEntity(this).forEach(this::updateBackReferencingFieldsForDeletion);
    }

    private void updateBackReferencingFieldsForDeletion(IAbstractBackReference<?> baseBackReference) {
        switch (baseBackReference.getType()) {
            case BACK_REFERENCE: {
                this.updateBackReferenceForDeletion((BackReference)baseBackReference);
                break;
            }
            case OPTIONAL_BACK_REFERENCE: {
                this.updateOptionalBackReferenceForDeletion((OptionalBackReference)baseBackReference);
                break;
            }
            case MULTI_BACK_REFERENCE: {
                break;
            }
            default: {
                throw InvalidArgumentException.forArgument((Object)baseBackReference.getType());
            }
        }
    }

    private void updateBaseBackReferencesWhenIsInsertedIntoDatabase() {
        this.getStoredFields().forEach(AbstractField::internalUpdateBackReferencingFieldsWhenIsInsertedIntoDatabase);
    }

    private void updateOptionalBackReferenceForDeletion(OptionalBackReference<?> optionalBackReference) {
        optionalBackReference.internalClear();
        optionalBackReference.setAsEditedAndRunPotentialUpdateAction();
    }

    private void updateStateForDeletion() {
        this.state = DatabaseObjectState.DELETED;
    }
}

