/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.reflection.reflectiontool.ReflectionTool;
import ch.nolix.system.objectdata.fieldvalidator.FieldValidator;
import ch.nolix.system.objectdata.model.AbstractEntity;
import ch.nolix.system.objectdata.modelflyweight.FieldFlyWeight;
import ch.nolix.system.objectdata.modelflyweight.VoidFieldFlyWeight;
import ch.nolix.systemapi.databaseobject.databaseobjectproperty.DatabaseObjectState;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.objectdata.fieldvalidator.IFieldValidator;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.modelflyweight.IFieldFlyWeight;
import ch.nolix.systemapi.objectdata.schemaview.IColumnView;

public abstract class AbstractField
implements IField {
    private static final IFieldValidator FIELD_VALIDATOR = new FieldValidator();
    private static final VoidFieldFlyWeight VOID_FIELD_FLY_WEIGHT = new VoidFieldFlyWeight();
    private AbstractEntity parentEntity;
    private IColumnView<ITable<IEntity>> parentColumn;
    private IFieldFlyWeight fieldFlyWeight = VOID_FIELD_FLY_WEIGHT;
    private boolean edited;

    @Override
    public final boolean belongsToEntity() {
        return this.parentEntity != null;
    }

    @Override
    public final String getName() {
        if (this.knowsParentColumn()) {
            return this.getStoredParentColumn().getName();
        }
        if (this.belongsToEntity()) {
            return ReflectionTool.getNameOfFirstFieldOfObjectThatStoresValue(this.getStoredParentEntity(), this);
        }
        throw InvalidArgumentException.forArgumentAndErrorPredicate(this, "cannot evaluate name");
    }

    @Override
    public final DatabaseObjectState getState() {
        if (!this.belongsToEntity()) {
            return DatabaseObjectState.NEW;
        }
        return this.getStateWhenBelongsToEntity();
    }

    @Override
    public final IColumnView<ITable<IEntity>> getStoredParentColumn() {
        FIELD_VALIDATOR.assertKnowsParentColumn(this);
        return this.parentColumn;
    }

    @Override
    public final AbstractEntity getStoredParentEntity() {
        FIELD_VALIDATOR.assertBelongsToEntity(this);
        return this.parentEntity;
    }

    @Override
    public final boolean isClosed() {
        return this.belongsToEntity() && this.getStoredParentEntity().isClosed();
    }

    @Override
    public final boolean isDeleted() {
        return this.belongsToEntity() && this.getStoredParentEntity().isDeleted();
    }

    @Override
    public final boolean isEdited() {
        return this.getState() == DatabaseObjectState.EDITED;
    }

    @Override
    public final boolean isConnectedWithRealDatabase() {
        return this.belongsToEntity() && this.getStoredParentEntity().isConnectedWithRealDatabase();
    }

    @Override
    public final boolean isLoaded() {
        return this.getState() == DatabaseObjectState.LOADED;
    }

    @Override
    public final boolean isNew() {
        return !this.belongsToEntity() || this.getStoredParentEntity().isDeleted();
    }

    @Override
    public final boolean knowsParentColumn() {
        return this.parentColumn != null;
    }

    @Override
    public final void setUpdateAction(Runnable updateAction) {
        this.fieldFlyWeight = FieldFlyWeight.wihUpdateAction(updateAction);
    }

    protected final IDataAdapterAndSchemaReader getStoredDataAndSchemaAdapter() {
        return this.getStoredParentEntity().getStoredMidDataAdapterAndSchemaReader();
    }

    protected final void setAsEditedAndRunPotentialUpdateAction() {
        if (this.belongsToEntity()) {
            this.getStoredParentEntity().setEdited();
        }
        this.edited = true;
        this.fieldFlyWeight.noteUpdate();
    }

    protected abstract void internalUpdateBackReferencingFieldsWhenIsInsertedIntoDatabase();

    final void setParentColumn(IColumnView<ITable<IEntity>> parentColumn) {
        Validator.assertThat(parentColumn).thatIsNamed("parent column").isNotNull();
        this.parentColumn = parentColumn;
    }

    final void setParentColumnFromParentTable() {
        String name = this.getName();
        IColumnView localParentColumn = this.getStoredParentEntity().getStoredParentTable().getStoredColumns().getStoredFirst(c -> c.hasName(name));
        this.setParentColumn(localParentColumn);
    }

    final void setParentEntity(AbstractEntity parentEntity) {
        Validator.assertThat(parentEntity).thatIsNamed("parent entity").isNotNull();
        FIELD_VALIDATOR.assertDoesNotBelongToEntity(this);
        this.parentEntity = parentEntity;
        this.setParentColumnFromParentTableIfParentEntityBelongsToTable(parentEntity);
    }

    private DatabaseObjectState getStateWhenBelongsToEntity() {
        DatabaseObjectState parentEntityState = this.getStoredParentEntity().getState();
        return switch (parentEntityState) {
            case DatabaseObjectState.NEW -> DatabaseObjectState.NEW;
            case DatabaseObjectState.LOADED -> DatabaseObjectState.LOADED;
            case DatabaseObjectState.EDITED -> this.getStateWhenParentFieldIsEdited();
            case DatabaseObjectState.DELETED -> DatabaseObjectState.DELETED;
            case DatabaseObjectState.CLOSED -> DatabaseObjectState.CLOSED;
            default -> throw InvalidArgumentException.forArgumentAndArgumentName((Object)this.getStoredParentEntity().getState(), "state");
        };
    }

    private DatabaseObjectState getStateWhenParentFieldIsEdited() {
        if (!this.edited) {
            return DatabaseObjectState.LOADED;
        }
        return DatabaseObjectState.EDITED;
    }

    private void setParentColumnFromParentTableIfParentEntityBelongsToTable(AbstractEntity parentEntity) {
        if (parentEntity.belongsToTable()) {
            this.setParentColumnFromParentTable();
        }
    }
}

