/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.model.AbstractField;
import ch.nolix.system.objectdata.model.BackReference;
import ch.nolix.system.objectdata.model.OptionalBackReference;
import ch.nolix.system.objectdata.model.Table;
import ch.nolix.systemapi.objectdata.model.IAbstractReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.model.ITable;

public abstract class AbstractReference<E extends IEntity>
extends AbstractField
implements IAbstractReference<E> {
    private final String referencedTableName;
    private Table<E> referencedTable;

    protected AbstractReference(String referencedTableName) {
        Validator.assertThat(referencedTableName).thatIsNamed("referenced table name").isNotBlank();
        this.referencedTableName = referencedTableName;
    }

    @Override
    public final String getReferencedTableId() {
        return this.getStoredReferencedTable().getId();
    }

    @Override
    public final String getReferencedTableName() {
        return this.referencedTableName;
    }

    @Override
    public final IContainer<IAbstractReference<IEntity>> getStoredAbstractReferencesThatAreBackReferencedFromThis() {
        return ImmutableList.createEmpty();
    }

    @Override
    public final ITable<E> getStoredReferencedTable() {
        this.extractReferencedTableIfNotExtracted();
        return this.referencedTable;
    }

    @Override
    public final boolean referencesBackEntity(IEntity entity) {
        return false;
    }

    @Override
    public final boolean referencesBackEntityWithId(String id) {
        return false;
    }

    @Override
    public final boolean referencesBackField(IField field) {
        return false;
    }

    protected final void updateProbableBackReferenceForSetOrAddedEntity(E entity) {
        for (IField iField : entity.internalGetStoredFields()) {
            switch (iField.getType()) {
                case BACK_REFERENCE: {
                    BackReference backReference = (BackReference)iField;
                    if (!backReference.referencesBackField(this)) break;
                    backReference.internalSetDirectlyBackReferencedEntityId(this.getStoredParentEntity().getId());
                    break;
                }
                case OPTIONAL_BACK_REFERENCE: {
                    OptionalBackReference optionalBackReference = (OptionalBackReference)iField;
                    if (!optionalBackReference.referencesBackField(this)) break;
                    optionalBackReference.internalSetDirectlyBackReferencedEntityId(this.getStoredParentEntity().getId());
                }
            }
        }
    }

    private boolean extractedReferencedTable() {
        return this.referencedTable != null;
    }

    private void extractReferencedTable() {
        this.referencedTable = this.loadReferencedTable();
    }

    private void extractReferencedTableIfNotExtracted() {
        if (!this.extractedReferencedTable()) {
            this.extractReferencedTable();
        }
    }

    private Table<E> loadReferencedTable() {
        return (Table)this.getStoredParentEntity().getStoredParentTable().getStoredParentDatabase().getStoredTableByName(this.getReferencedTableName());
    }
}

