/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.fieldvalidator.FieldValidator;
import ch.nolix.system.objectdata.model.AbstractBackReference;
import ch.nolix.system.objectdata.model.AbstractEntity;
import ch.nolix.system.objectdata.model.Entity;
import ch.nolix.system.objectdata.modelsearcher.EntitySearcher;
import ch.nolix.systemapi.midschema.fieldproperty.ContentType;
import ch.nolix.systemapi.objectdata.fieldvalidator.IFieldValidator;
import ch.nolix.systemapi.objectdata.model.IAbstractReference;
import ch.nolix.systemapi.objectdata.model.IBackReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IField;
import ch.nolix.systemapi.objectdata.modelsearcher.IEntitySearcher;

public final class BackReference<E extends IEntity>
extends AbstractBackReference<E>
implements IBackReference<E> {
    private static final IEntitySearcher ENTITY_SEARCHER = new EntitySearcher();
    private static final IFieldValidator FIELD_VALIDATOR = new FieldValidator();
    private String backReferencedEntityId;

    private BackReference(String backReferencedTableName, String backReferencedFieldName) {
        super(backReferencedTableName, backReferencedFieldName);
    }

    public static <E2 extends Entity> BackReference<E2> forEntityAndBackReferencedFieldName(Class<E2> type, String backReferencedFieldName) {
        return new BackReference(type.getSimpleName(), backReferencedFieldName);
    }

    public static BackReference<AbstractEntity> forEntityWithTableNameAndBackReferencedFieldName(String tableName, String backReferencedFieldName) {
        return new BackReference<AbstractEntity>(tableName, backReferencedFieldName);
    }

    @Override
    public IContainer<IAbstractReference<IEntity>> getStoredAbstractReferencesThatAreBackReferencedFromThis() {
        if (this.isEmpty()) {
            return ImmutableList.createEmpty();
        }
        IAbstractReference backReferencedField = (IAbstractReference)ENTITY_SEARCHER.getStoredFieldByName((IEntity)this.getStoredBackReferencedEntity(), this.getBackReferencedFieldName());
        return ImmutableList.withElement(backReferencedField, new IAbstractReference[0]);
    }

    @Override
    public ContentType getType() {
        return ContentType.BACK_REFERENCE;
    }

    @Override
    public String getBackReferencedEntityId() {
        FIELD_VALIDATOR.assertIsNotEmpty(this);
        return this.backReferencedEntityId;
    }

    @Override
    public E getStoredBackReferencedEntity() {
        return this.getStoredBackReferencedTable().getStoredEntityById(this.getBackReferencedEntityId());
    }

    @Override
    public IContainer<IField> internalGetStoredSubFields() {
        return ImmutableList.createEmpty();
    }

    @Override
    public void internalSetOptionalContent(Object content) {
        this.backReferencedEntityId = (String)content;
    }

    @Override
    public boolean isEmpty() {
        return this.backReferencedEntityId == null;
    }

    @Override
    public boolean isMandatory() {
        return true;
    }

    @Override
    public boolean referencesBackEntity(IEntity entity) {
        return this.containsAny() && entity != null && this.getBackReferencedEntityId().equals(entity.getId());
    }

    @Override
    public boolean referencesBackEntity() {
        return this.containsAny();
    }

    @Override
    public boolean referencesBackEntityWithId(String id) {
        return this.containsAny() && this.getBackReferencedEntityId().equals(id);
    }

    void internalClear() {
        this.backReferencedEntityId = null;
        this.setAsEditedAndRunPotentialUpdateAction();
    }

    void internalSetDirectlyBackReferencedEntityId(String backReferencedEntityId) {
        this.backReferencedEntityId = backReferencedEntityId;
    }
}

