/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.errorcontrol.invalidargumentexception.InvalidArgumentException;
import ch.nolix.system.objectdata.model.BackReference;
import ch.nolix.system.objectdata.model.MultiBackReference;
import ch.nolix.system.objectdata.model.OptionalBackReference;
import ch.nolix.system.objectdata.modelsearcher.EntitySearcher;
import ch.nolix.systemapi.midschema.fieldproperty.ContentType;
import ch.nolix.systemapi.objectdata.model.IAbstractBackReference;
import ch.nolix.systemapi.objectdata.model.IAbstractReference;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.modelsearcher.IEntitySearcher;
import java.util.Optional;

public final class BaseReferenceUpdater {
    private static final IEntitySearcher ENTITY_SEARCHER = new EntitySearcher();

    public <E extends IEntity> void ofBaseReferenceUpdatePotentialBaseBackReferenceForAddOrSetEntity(IAbstractReference<E> baseReference, E entity) {
        Optional<IAbstractBackReference<IEntity>> baseBackReference = ENTITY_SEARCHER.getOptionalStoredAbstractBackReferenceThatCanBackReferenceAbstractReference(entity, baseReference);
        baseBackReference.ifPresent(bbr -> this.toBaseBackReferenceAddOrSetEntity((IAbstractBackReference<?>)bbr, (IEntity)baseReference.getStoredParentEntity()));
    }

    private void toBaseBackReferenceAddOrSetEntity(IAbstractBackReference<?> baseBackReference, IEntity entity) {
        ContentType type = baseBackReference.getType();
        switch (type) {
            case BACK_REFERENCE: {
                BackReference backReference = (BackReference)baseBackReference;
                backReference.internalSetDirectlyBackReferencedEntityId(entity.getId());
                backReference.setAsEditedAndRunPotentialUpdateAction();
                break;
            }
            case OPTIONAL_BACK_REFERENCE: {
                OptionalBackReference optionalBackReference = (OptionalBackReference)baseBackReference;
                optionalBackReference.internalSetDirectlyBackReferencedEntityId(entity.getId());
                optionalBackReference.setAsEditedAndRunPotentialUpdateAction();
                break;
            }
            case MULTI_BACK_REFERENCE: {
                MultiBackReference multiBackReference = (MultiBackReference)baseBackReference;
                multiBackReference.internalAddBackReferencedEntityId(entity.getId());
                multiBackReference.setAsEditedAndRunPotentialUpdateAction();
                break;
            }
            default: {
                throw InvalidArgumentException.forArgument((Object)type);
            }
        }
    }
}

