/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.resourcecontrol.resourcevalidator.ResourceValidator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.system.objectdata.model.AbstractImmutableDatabaseObject;
import ch.nolix.system.objectdata.model.Table;
import ch.nolix.systemapi.middata.adapter.IDataReader;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.schemaview.IColumnView;
import ch.nolix.systemapi.objectdata.schemaview.IContentModelView;

public final class Column
extends AbstractImmutableDatabaseObject
implements IColumnView<ITable<IEntity>> {
    private final String id;
    private final String name;
    private final IContentModelView<ITable<IEntity>> contentModelView;
    private final Table<IEntity> parentTable;
    private final IDataReader midDataReader;

    private Column(String id, String name, IContentModelView<ITable<IEntity>> contentModelView, Table<IEntity> parentTable, IDataReader midDataReader) {
        Validator.assertThat(id).thatIsNamed("id").isNotBlank();
        Validator.assertThat(name).thatIsNamed("name").isNotBlank();
        Validator.assertThat(contentModelView).thatIsNamed(IContentModelView.class).isNotNull();
        ResourceValidator.assertIsOpen(parentTable);
        ResourceValidator.assertIsOpen(midDataReader);
        this.id = id;
        this.name = name;
        this.contentModelView = contentModelView;
        this.parentTable = parentTable;
        this.midDataReader = midDataReader;
    }

    static Column withIdAndNameAndContentModelViewAndParentTableAndMidDataReader(String id, String name, IContentModelView<ITable<IEntity>> contentModelView, Table<IEntity> parentTable, IDataReader midDataReader) {
        return new Column(id, name, contentModelView, parentTable, midDataReader);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IContentModelView<ITable<IEntity>> getContentModel() {
        return this.contentModelView;
    }

    @Override
    public ITable<IEntity> getStoredParentTable() {
        return this.parentTable;
    }

    @Override
    public boolean internalContainsGivenValueInPersistedData(String value) {
        return this.midDataReader.tableContainsEntityWithValueAtColumn(this.getStoredParentTable().getName(), this.getName(), value);
    }

    @Override
    public boolean internalContainsGivenValueInPersistedDataIgnoringGivenEntities(String value, IContainer<String> entitiesToIgnoreIds) {
        return this.midDataReader.tableContainsEntityWithValueAtColumnIgnoringEntities(this.getStoredParentTable().getName(), this.getName(), value, entitiesToIgnoreIds);
    }
}

