/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.core.resourcecontrol.closecontroller.CloseController;
import ch.nolix.core.resourcecontrol.resourcevalidator.ResourceValidator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.resourcecontrol.closecontroller.ICloseController;
import ch.nolix.system.objectdata.model.DatabaseTableLoader;
import ch.nolix.system.objectdata.model.Table;
import ch.nolix.systemapi.databaseobject.databaseobjectproperty.DatabaseObjectState;
import ch.nolix.systemapi.databaseobject.databaseobjectrequest.EditingRequestable;
import ch.nolix.systemapi.middata.adapter.IDataAdapterAndSchemaReader;
import ch.nolix.systemapi.objectdata.model.IDatabase;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IEntityTypeSet;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.time.moment.ITime;

public final class Database
implements IDatabase {
    private static final DatabaseTableLoader DATABASE_TABLE_LOADER = new DatabaseTableLoader();
    private final IEntityTypeSet entityTypeSet;
    private final ITime schemaTimestamp;
    private final IContainer<? extends ITable<IEntity>> tables;
    private final IDataAdapterAndSchemaReader midDataAdapterAndSchemaReader;
    private final ICloseController closeController = CloseController.forElement(this);

    private Database(IEntityTypeSet entityTypeSet, IDataAdapterAndSchemaReader midDataAdapterAndSchemaReader) {
        ResourceValidator.assertIsOpen(midDataAdapterAndSchemaReader);
        Validator.assertThat(entityTypeSet).thatIsNamed(IEntityTypeSet.class).isNotNull();
        this.entityTypeSet = entityTypeSet;
        this.schemaTimestamp = midDataAdapterAndSchemaReader.getSchemaTimestamp();
        this.midDataAdapterAndSchemaReader = midDataAdapterAndSchemaReader;
        this.createCloseDependencyTo(this.midDataAdapterAndSchemaReader);
        this.tables = this.loadTables();
    }

    public static Database withEntityTypeSetAndMidDataAdapterAndSchemaReader(IEntityTypeSet entityTypeSet, IDataAdapterAndSchemaReader midDataAdapterAndSchemaReader) {
        return new Database(entityTypeSet, midDataAdapterAndSchemaReader);
    }

    @Override
    public IEntityTypeSet getEntityTypeSet() {
        return this.entityTypeSet;
    }

    @Override
    public String getName() {
        return this.getStoredMidDataAdapterAndSchemaReader().getDatabaseName();
    }

    @Override
    public ITime getSchemaTimestamp() {
        return this.schemaTimestamp;
    }

    @Override
    public DatabaseObjectState getState() {
        if (this.getStoredMidDataAdapterAndSchemaReader().isClosed()) {
            return DatabaseObjectState.CLOSED;
        }
        if (this.getStoredTables().containsAny(EditingRequestable::isEdited)) {
            return DatabaseObjectState.EDITED;
        }
        return DatabaseObjectState.LOADED;
    }

    @Override
    public ICloseController getStoredCloseController() {
        return this.closeController;
    }

    @Override
    public <E extends IEntity> IContainer<E> getStoredEntitiesByType(Class<E> type) {
        ITable<E> table = this.getStoredTableByEntityType(type);
        return table.getStoredEntities();
    }

    @Override
    public <E extends IEntity> ITable<E> getStoredTableByEntityType(Class<E> entityType) {
        String tableName = entityType.getSimpleName();
        return this.getStoredTableByName(tableName);
    }

    @Override
    public ITable<IEntity> getStoredTableByName(String name) {
        return this.getStoredTables().getStoredFirst(t -> t.hasName(name));
    }

    @Override
    public IContainer<? extends ITable<IEntity>> getStoredTables() {
        return this.tables;
    }

    @Override
    public <E extends IEntity> IDatabase insertEntity(E entity) {
        Class<?> entityType = entity.getClass();
        ITable<?> table = this.getStoredTableByEntityType(entityType);
        table.insertEntity(entity);
        return this;
    }

    @Override
    public boolean isClosed() {
        return this.getStoredMidDataAdapterAndSchemaReader().isClosed();
    }

    @Override
    public boolean isConnectedWithRealDatabase() {
        return true;
    }

    @Override
    public boolean isDeleted() {
        return this.getState() == DatabaseObjectState.DELETED;
    }

    @Override
    public boolean isEdited() {
        return this.getState() == DatabaseObjectState.EDITED;
    }

    @Override
    public boolean isLoaded() {
        return this.getState() == DatabaseObjectState.LOADED;
    }

    @Override
    public boolean isNew() {
        return this.getState() == DatabaseObjectState.NEW;
    }

    @Override
    public void noteClose() {
        for (ITable iTable : this.getStoredTables()) {
            ((Table)iTable).close();
        }
        this.midDataAdapterAndSchemaReader.close();
    }

    IDataAdapterAndSchemaReader getStoredMidDataAdapterAndSchemaReader() {
        return this.midDataAdapterAndSchemaReader;
    }

    private IContainer<Table<IEntity>> loadTables() {
        return ImmutableList.forIterable(DATABASE_TABLE_LOADER.loadTablesForDatabase(this));
    }
}

