/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.generalexception.WrapperException;
import ch.nolix.core.reflection.reflectiontool.ReflectionTool;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.coreapi.container.list.ILinkedList;
import ch.nolix.system.objectdata.model.AbstractField;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.modelextractor.IEntityFieldExtractor;
import java.lang.reflect.Field;

public final class EntityFieldExtractor
implements IEntityFieldExtractor<IEntity, AbstractField> {
    private static IContainer<AbstractField> extractStoredFieldsFromEntityWhenEntityIsNotNull(IEntity entity) {
        LinkedList<AbstractField> fields = LinkedList.createEmpty();
        EntityFieldExtractor.fillUpFieldsFromEntityIntoList(entity, fields);
        return fields;
    }

    private static void fillUpFieldsFromEntityIntoList(IEntity entity, ILinkedList<AbstractField> list) {
        Class<?> entityClass = entity.getClass();
        while (entityClass != null) {
            EntityFieldExtractor.fillUpFieldsFromEntityAndEntityClassIntoList(entity, entityClass, list);
            entityClass = entityClass.getSuperclass();
        }
    }

    private static void fillUpFieldsFromEntityAndEntityClassIntoList(IEntity entity, Class<?> entityClass, ILinkedList<AbstractField> list) {
        Field[] fieldArray = entityClass.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (EntityFieldExtractor.isField(f)) {
                EntityFieldExtractor.fillUpFieldFromEntityAndJavaFieldIntoList(entity, f, list);
            }
            ++n2;
        }
    }

    private static boolean isField(Field javaField) {
        return ReflectionTool.hasGivenTypeOrSuperType(javaField, AbstractField.class);
    }

    private static void fillUpFieldFromEntityAndJavaFieldIntoList(IEntity entity, Field javaField, ILinkedList<AbstractField> list) {
        javaField.setAccessible(true);
        try {
            AbstractField field = (AbstractField)javaField.get(entity);
            list.addAtEnd(field);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw WrapperException.forError(illegalAccessException);
        }
    }

    @Override
    public IContainer<AbstractField> extractStoredFieldsFromEntity(IEntity entity) {
        if (entity == null) {
            return ImmutableList.createEmpty();
        }
        return EntityFieldExtractor.extractStoredFieldsFromEntityWhenEntityIsNotNull(entity);
    }
}

