/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.core.container.immutablelist.ImmutableList;
import ch.nolix.core.container.linkedlist.LinkedList;
import ch.nolix.core.errorcontrol.validator.Validator;
import ch.nolix.coreapi.container.base.IContainer;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.IEntityTypeSet;

public final class EntityTypeSet
implements IEntityTypeSet {
    public static final EntityTypeSet EMPTY_SCHEMA = new EntityTypeSet(ImmutableList.createEmpty());
    private final ImmutableList<Class<? extends IEntity>> entityTypes;

    private EntityTypeSet(IContainer<Class<? extends IEntity>> entityTypes) {
        Validator.assertThat(entityTypes).thatIsNamed("entity types").containsDistinctNonNullElemensOnly();
        this.entityTypes = ImmutableList.forIterable(entityTypes);
    }

    public static EntityTypeSet withEntityType(Class<?> entityType, Class<?> ... entityTypes) {
        LinkedList<Class<? extends IEntity>> allEntityTypes = LinkedList.createEmpty();
        allEntityTypes.addAtEnd(entityType);
        Class<?>[] classArray = entityTypes;
        int n = entityTypes.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> et = classArray[n2];
            allEntityTypes.addAtEnd(et);
            ++n2;
        }
        return new EntityTypeSet(allEntityTypes);
    }

    public static EntityTypeSet withEntityTypes(IContainer<Class<? extends IEntity>> entityTypes) {
        return new EntityTypeSet(entityTypes);
    }

    @Override
    public IContainer<Class<? extends IEntity>> getEntityTypes() {
        return this.entityTypes;
    }
}

