/*
 * Decompiled with CFR 0.152.
 */
package ch.nolix.system.objectdata.model;

import ch.nolix.system.objectdata.model.AbstractEntity;
import ch.nolix.system.objectdata.model.AbstractField;
import ch.nolix.system.objectdata.model.BackReference;
import ch.nolix.system.objectdata.model.MultiBackReference;
import ch.nolix.system.objectdata.model.MultiReference;
import ch.nolix.system.objectdata.model.MultiValueField;
import ch.nolix.system.objectdata.model.OptionalBackReference;
import ch.nolix.system.objectdata.model.OptionalReference;
import ch.nolix.system.objectdata.model.OptionalValueField;
import ch.nolix.system.objectdata.model.Reference;
import ch.nolix.system.objectdata.model.ValueField;
import ch.nolix.systemapi.midschema.fieldproperty.ContentType;
import ch.nolix.systemapi.objectdata.model.IEntity;
import ch.nolix.systemapi.objectdata.model.ITable;
import ch.nolix.systemapi.objectdata.schemaview.IAbstractBackReferenceModelView;
import ch.nolix.systemapi.objectdata.schemaview.IAbstractReferenceModelView;
import ch.nolix.systemapi.objectdata.schemaview.IAbstractValueModelView;
import ch.nolix.systemapi.objectdata.schemaview.IColumnView;
import ch.nolix.systemapi.objectdata.schemaview.IContentModelView;

public final class FieldFromColumnCreator {
    private FieldFromColumnCreator() {
    }

    public static AbstractField createFieldFromAndWithColumnView(IColumnView<ITable<IEntity>> columnView) {
        AbstractField field = FieldFromColumnCreator.createFieldFromColumnView(columnView);
        field.setParentColumn(columnView);
        return field;
    }

    private static AbstractField createFieldFromColumnView(IColumnView<ITable<IEntity>> columnView) {
        IContentModelView<ITable<IEntity>> contentModelView = columnView.getContentModel();
        return FieldFromColumnCreator.createFieldFromContentModelView(contentModelView);
    }

    private static AbstractField createFieldFromContentModelView(IContentModelView<ITable<IEntity>> contentModelView) {
        ContentType contentType = contentModelView.getContentType();
        return switch (contentType) {
            case ContentType.VALUE -> ValueField.withValueType(((IAbstractValueModelView)contentModelView).getValueType());
            case ContentType.OPTIONAL_VALUE -> OptionalValueField.withValueType(((IAbstractValueModelView)contentModelView).getValueType());
            case ContentType.MULTI_VALUE -> MultiValueField.withValueType(((IAbstractValueModelView)contentModelView).getValueType());
            case ContentType.REFERENCE -> FieldFromColumnCreator.createReferenceFromAbstractReferenceModelView((IAbstractReferenceModelView)contentModelView);
            case ContentType.OPTIONAL_REFERENCE -> FieldFromColumnCreator.createOptionalReferenceFromAbstractReferenceModelView((IAbstractReferenceModelView)contentModelView);
            case ContentType.MULTI_REFERENCE -> FieldFromColumnCreator.createMultiReferenceFromAbstractReferenceModelView((IAbstractReferenceModelView)contentModelView);
            case ContentType.BACK_REFERENCE -> FieldFromColumnCreator.createBackReferenceFromAbstractBackReferenceModelView((IAbstractBackReferenceModelView)contentModelView);
            case ContentType.OPTIONAL_BACK_REFERENCE -> FieldFromColumnCreator.createOptionalBackReferenceFromAbstractBackReferenceModelView((IAbstractBackReferenceModelView)contentModelView);
            case ContentType.MULTI_BACK_REFERENCE -> FieldFromColumnCreator.createMultiBackReferenceFromAbstractBackReferenceModelView((IAbstractBackReferenceModelView)contentModelView);
            default -> throw new MatchException(null, null);
        };
    }

    private static Reference<AbstractEntity> createReferenceFromAbstractReferenceModelView(IAbstractReferenceModelView<ITable<IEntity>> abstractReferenceModelView) {
        String referencedtableName = abstractReferenceModelView.getStoredReferencedTable().getName();
        return Reference.forTable(referencedtableName);
    }

    private static OptionalReference<AbstractEntity> createOptionalReferenceFromAbstractReferenceModelView(IAbstractReferenceModelView<ITable<IEntity>> abstractReferenceModelView) {
        String referencedtableName = abstractReferenceModelView.getStoredReferencedTable().getName();
        return OptionalReference.forTable(referencedtableName);
    }

    private static MultiReference<AbstractEntity> createMultiReferenceFromAbstractReferenceModelView(IAbstractReferenceModelView<ITable<IEntity>> abstractReferenceModelView) {
        String referencedtableName = abstractReferenceModelView.getStoredReferencedTable().getName();
        return MultiReference.forTable(referencedtableName);
    }

    private static BackReference<AbstractEntity> createBackReferenceFromAbstractBackReferenceModelView(IAbstractBackReferenceModelView<IColumnView<ITable<IEntity>>, ITable<IEntity>> abstractBackReferenceModelView) {
        IColumnView<ITable<IEntity>> backReferencedColumn = abstractBackReferenceModelView.getBackReferencedColumn();
        ITable<IEntity> backReferencedTable = backReferencedColumn.getStoredParentTable();
        String backReferencedTableName = backReferencedTable.getName();
        String backReferencedFieldName = backReferencedColumn.getName();
        return BackReference.forEntityWithTableNameAndBackReferencedFieldName(backReferencedTableName, backReferencedFieldName);
    }

    private static OptionalBackReference<AbstractEntity> createOptionalBackReferenceFromAbstractBackReferenceModelView(IAbstractBackReferenceModelView<IColumnView<ITable<IEntity>>, ITable<IEntity>> abstractBackReferenceModelView) {
        IColumnView<ITable<IEntity>> backReferencedColumn = abstractBackReferenceModelView.getBackReferencedColumn();
        ITable<IEntity> backReferencedTable = backReferencedColumn.getStoredParentTable();
        String backReferencedTableName = backReferencedTable.getName();
        String backReferencedFieldName = backReferencedColumn.getName();
        return OptionalBackReference.forEntityWithTableNameAndBackReferencedFieldName(backReferencedTableName, backReferencedFieldName);
    }

    private static MultiBackReference<AbstractEntity> createMultiBackReferenceFromAbstractBackReferenceModelView(IAbstractBackReferenceModelView<IColumnView<ITable<IEntity>>, ITable<IEntity>> abstractBackReferenceModelView) {
        IColumnView<ITable<IEntity>> backReferencedColumn = abstractBackReferenceModelView.getBackReferencedColumn();
        ITable<IEntity> backReferencedTable = backReferencedColumn.getStoredParentTable();
        String backReferencedTableName = backReferencedTable.getName();
        String backReferencedFieldName = backReferencedColumn.getName();
        return MultiBackReference.forBackReferencedTableAndBaseReference(backReferencedTableName, backReferencedFieldName);
    }
}

